/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types.eqrule;

import java.util.Optional;
import nz.org.riskscape.engine.types.GeomType;
import nz.org.riskscape.engine.types.MultiGeom;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.eqrule.Coercer;
import nz.org.riskscape.engine.types.eqrule.EquivalenceRule;
import nz.org.riskscape.engine.typeset.TypeRules;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class SingleGeomToMultiGeomRule
implements EquivalenceRule {
    @Override
    public Optional<Coercer> getCoercer(TypeRules typeRules, Type sourceType, Type targetType) {
        Optional<MultiGeom> multiTarget = targetType.find(MultiGeom.class);
        if (!multiTarget.isPresent()) {
            return Optional.empty();
        }
        Type containedTargetType = multiTarget.get().getContainedType();
        if (sourceType.find(GeomType.Line.class).isPresent() && typeRules.isAssignable(sourceType, containedTargetType)) {
            return Optional.of(Coercer.build(sourceType, targetType, x -> {
                LineString line = (LineString)x;
                return line.getFactory().createMultiLineString(new LineString[]{line});
            }));
        }
        if (sourceType.find(GeomType.Point.class).isPresent() && typeRules.isAssignable(sourceType, containedTargetType)) {
            return Optional.of(Coercer.build(sourceType, targetType, x -> {
                Point point = (Point)x;
                return point.getFactory().createMultiPoint(new Point[]{point});
            }));
        }
        if (sourceType.find(GeomType.Polygon.class).isPresent() && typeRules.isAssignable(sourceType, containedTargetType)) {
            return Optional.of(Coercer.build(sourceType, targetType, x -> {
                Polygon polygon = (Polygon)x;
                return polygon.getFactory().createMultiPolygon(new Polygon[]{polygon});
            }));
        }
        return Optional.empty();
    }
}

