/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types.eqrule;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.eqrule.Coercer;
import nz.org.riskscape.engine.types.eqrule.EquivalenceRule;
import nz.org.riskscape.engine.typeset.TypeRules;
import nz.org.riskscape.engine.typeset.TypeSet;
import nz.org.riskscape.problem.Problem;

public class PartialStructRule
implements EquivalenceRule {
    @Override
    public Optional<Coercer> getCoercer(TypeRules typeRules, Type sourceType, Type targetType) {
        Struct targetStruct = targetType.find(Struct.class).orElse(null);
        Struct sourceStruct = sourceType.find(Struct.class).orElse(null);
        if (targetStruct != null && sourceStruct != null) {
            Optional[] coercers = new Optional[targetStruct.size()];
            int[] sourceIndices = new int[coercers.length];
            List<Struct.StructMember> targetMembers = targetStruct.getMembers();
            typeRules.debug("Checking members {} in source...", targetStruct.getMemberKeys());
            for (int idx = 0; idx < sourceIndices.length; ++idx) {
                Struct.StructMember targetMember = targetMembers.get(idx);
                Struct.StructMember sourceMember = sourceStruct.getEntry(targetMember.getKey());
                int n = sourceIndices[idx] = sourceMember == null ? -1 : sourceMember.getIndex();
                if (sourceMember == null) {
                    if (targetMember.getType().isNullable()) {
                        typeRules.debug("  member {} is missing from source, but target is nullable, can be ignored", targetMember);
                        coercers[idx] = Optional.empty();
                        continue;
                    }
                    typeRules.debug("  member {} is missing from source, no safe coercion possible", targetMember);
                    return Optional.empty();
                }
                if (typeRules.isAssignable(sourceMember.getType(), targetMember.getType())) {
                    typeRules.debug("  {} is directly assignable to {}", sourceMember.getType(), targetMember);
                    coercers[idx] = Optional.empty();
                    continue;
                }
                Optional<Coercer> memberCoercer = typeRules.findEquivalenceCoercer(sourceMember.getType(), targetMember.getType());
                if (memberCoercer.isPresent()) {
                    typeRules.debug("  {} is assignable to {} with coercion", sourceMember.getType(), targetMember);
                    coercers[idx] = memberCoercer;
                    continue;
                }
                typeRules.debug("  {} is not assignable to {} with coercion, no safe coercion possible", sourceMember.getType(), targetMember);
                return Optional.empty();
            }
            return Optional.of(Coercer.build(sourceType, targetType, srcValue -> {
                Tuple targetTuple = new Tuple(targetStruct);
                Tuple sourceTuple = (Tuple)srcValue;
                for (int idx = 0; idx < sourceIndices.length; ++idx) {
                    if (sourceIndices[idx] == -1) continue;
                    Object rawValue = sourceTuple.fetch(sourceIndices[idx]);
                    targetTuple.set(idx, coercers[idx].map(c -> c.apply(rawValue)).orElse(rawValue));
                }
                return targetTuple;
            }));
        }
        return Optional.empty();
    }

    public static List<Problem> describeMismatch(TypeSet typeset, Struct given, Struct expected) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        for (Struct.StructMember member : expected.getMembers()) {
            if (given.hasMember(member.getKey())) {
                Type givenType = given.getEntry(member.getKey()).getType();
                if (typeset.isAssignable(givenType, member.getType()) || typeset.findEquivalenceCoercer(givenType, member.getType()).isPresent()) continue;
                problems.add(TypeProblems.get().mismatch((Object)member, member.getType(), givenType));
                continue;
            }
            if (member.getType().isNullable()) continue;
            problems.add(GeneralProblems.get().required(member));
        }
        return problems;
    }
}

