/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types.eqrule;

import java.util.Optional;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.eqrule.Coercer;
import nz.org.riskscape.engine.types.eqrule.EquivalenceRule;
import nz.org.riskscape.engine.typeset.TypeRules;

public class NullableRule
implements EquivalenceRule {
    @Override
    public Optional<Coercer> getCoercer(TypeRules typeRules, Type sourceType, Type targetType) {
        if (targetType.isNullable()) {
            Type denulledTarget = Nullable.strip(targetType);
            Type denulledSource = Nullable.strip(sourceType);
            return typeRules.findEquivalenceCoercer(denulledSource, denulledTarget).map(child -> Coercer.build(sourceType, Nullable.of(child.getTargetType()), input -> {
                if (input == null) {
                    return null;
                }
                return child.apply(input);
            }));
        }
        return Optional.empty();
    }
}

