/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types.ancestor;

import java.lang.reflect.ParameterizedType;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.ancestor.AncestorRule;
import nz.org.riskscape.engine.types.ancestor.AncestorType;
import nz.org.riskscape.engine.typeset.TypeRules;

public abstract class TypeSafeAncestorRule<T1 extends Type, T2 extends Type>
implements AncestorRule {
    private final Class<T1> typeClass1;
    private final Class<T2> typeClass2;

    public TypeSafeAncestorRule() {
        ParameterizedType superType = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.typeClass1 = (Class)superType.getActualTypeArguments()[0];
        this.typeClass2 = (Class)superType.getActualTypeArguments()[1];
    }

    @Override
    public Optional<AncestorType> computeAncestor(TypeRules typeRules, Type type1, Type type2) {
        if (this.typeClass1.isInstance(type1) && this.typeClass2.isInstance(type2)) {
            return this.computeSafeAncestor(typeRules, (Type)this.typeClass1.cast(type1), (Type)this.typeClass2.cast(type2));
        }
        return Optional.empty();
    }

    protected abstract Optional<AncestorType> computeSafeAncestor(TypeRules var1, T1 var2, T2 var3);

    @Generated
    public TypeSafeAncestorRule(Class<T1> typeClass1, Class<T2> typeClass2) {
        this.typeClass1 = typeClass1;
        this.typeClass2 = typeClass2;
    }
}

