/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types.ancestor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.ancestor.AncestorType;
import nz.org.riskscape.engine.types.ancestor.TypeSafeAncestorRule;
import nz.org.riskscape.engine.typeset.TypeRules;

public class StructMemberAncestorRule
extends TypeSafeAncestorRule<Struct, Struct> {
    @Override
    protected Optional<AncestorType> computeSafeAncestor(TypeRules typeRules, Struct type1, Struct type2) {
        if (new HashSet<String>(type1.getMemberKeys()).equals(new HashSet<String>(type2.getMemberKeys()))) {
            ArrayList<AncestorType> memberAncestors = new ArrayList<AncestorType>(type1.size());
            Struct.StructBuilder structBuilder = Struct.builder();
            for (Struct.StructMember member1 : type1.getMembers()) {
                Struct.StructMember member2 = type2.getMember(member1.getKey()).get();
                AncestorType memberAncestor = typeRules.computeAncestorType(member1.getType(), member2.getType()).orElse(null);
                if (memberAncestor == null) {
                    return Optional.empty();
                }
                memberAncestors.add(memberAncestor);
                structBuilder.add(member1.getKey(), memberAncestor.getType());
            }
            Struct ancestorStruct = structBuilder.build();
            AncestorType.Converter converter = source -> {
                Tuple input = (Tuple)source;
                Tuple output = Tuple.of(ancestorStruct);
                Iterator iterator = memberAncestors.iterator();
                int index = 0;
                for (Object value : input.getValues()) {
                    output.set(index++, ((AncestorType)iterator.next()).getConvert().apply(value));
                }
                return output;
            };
            return Optional.of(AncestorType.of(ancestorStruct, converter));
        }
        return Optional.empty();
    }
}

