/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types.ancestor;

import java.util.Optional;
import nz.org.riskscape.engine.types.Referenced;
import nz.org.riskscape.engine.types.ancestor.AncestorType;
import nz.org.riskscape.engine.types.ancestor.TypeSafeAncestorRule;
import nz.org.riskscape.engine.typeset.TypeRules;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Envelope;

public class ReferencedAncestorRule
extends TypeSafeAncestorRule<Referenced, Referenced> {
    @Override
    public Optional<AncestorType> computeSafeAncestor(TypeRules typeRules, Referenced lhs, Referenced rhs) {
        return typeRules.computeAncestorType(lhs.getUnderlyingType(), rhs.getUnderlyingType()).map(ancestor -> {
            if (!CRS.equalsIgnoreMetadata((Object)lhs.getCrs(), (Object)rhs.getCrs())) {
                return ancestor;
            }
            return ancestor.withNewType(new Referenced(ancestor.getType(), lhs.getCrs(), this.combineEnvelopes(lhs.getEnvelope(), rhs.getEnvelope())));
        });
    }

    private Envelope combineEnvelopes(Envelope a, Envelope b) {
        if (a == null || b == null) {
            return null;
        }
        Envelope combinedEnvelope = new Envelope();
        combinedEnvelope.expandToInclude(a);
        combinedEnvelope.expandToInclude(b);
        return combinedEnvelope;
    }
}

