/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types.ancestor;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.ancestor.AncestorType;
import nz.org.riskscape.engine.types.ancestor.TypeSafeAncestorRule;
import nz.org.riskscape.engine.typeset.TypeRules;

public class RSListAncestorRule
extends TypeSafeAncestorRule<RSList, RSList> {
    @Override
    protected Optional<AncestorType> computeSafeAncestor(TypeRules typeRules, RSList type1, RSList type2) {
        Type containedType1 = type1.getContainedType();
        Type containedType2 = type2.getContainedType();
        return typeRules.computeAncestorType(containedType1, containedType2).map(ancestorType -> AncestorType.of(RSList.create(ancestorType.getType()), object -> {
            if (ancestorType.isConverting()) {
                List list = (List)object;
                return Lists.transform((List)list, listObj -> ancestorType.getConvert().apply(listObj));
            }
            return object;
        }));
    }
}

