/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types.ancestor;

import java.util.Optional;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.ancestor.AncestorRule;
import nz.org.riskscape.engine.types.ancestor.AncestorType;
import nz.org.riskscape.engine.typeset.TypeRules;

public class NullableAncestorRule
implements AncestorRule {
    @Override
    public Optional<AncestorType> computeAncestor(TypeRules typeRules, Type lhs, Type rhs) {
        if (lhs.isNullable() || rhs.isNullable()) {
            return typeRules.computeAncestorType(Nullable.strip(lhs), Nullable.strip(rhs)).map(ancestor -> {
                AncestorType newType = ancestor.withNewType(Nullable.of(ancestor.getType()));
                if (ancestor.isConverting()) {
                    return newType.compose((composed, value) -> {
                        if (value == null) {
                            return null;
                        }
                        return composed.apply(value);
                    });
                }
                return newType;
            });
        }
        return Optional.empty();
    }
}

