/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeInformation;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.types.WrappingType;
import nz.org.riskscape.engine.typexp.AST;
import nz.org.riskscape.engine.typexp.ComplexTypeConstructor;
import nz.org.riskscape.engine.typexp.TypeArgumentException;

public class WithinSet
implements WrappingType {
    public static final ComplexTypeConstructor TYPE_CONSTRUCTOR = (typeBuilder, type) -> {
        List<AST> args = type.args();
        Type subType = typeBuilder.expectType(args.remove(0), ast -> new TypeArgumentException(type, "first argument must be a type"));
        List<Object> values = typeBuilder.expectConstantsOfType(type, subType, args, 1);
        return new WithinSet(subType, values);
    };
    public static final TypeInformation TYPE_INFORMATION = new TypeInformation("set", WithinSet.class, Object.class, TYPE_CONSTRUCTOR);
    public static final Joiner JOINER = Joiner.on((String)", ");
    private final Set<?> allowed;
    private final Type underlyingType;

    public static WithinSet fromEnum(Class<?> enumClass) {
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException("Class is not an enum:" + String.valueOf(enumClass));
        }
        Class<?> castClass = enumClass;
        Converter enumConverter = CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_UNDERSCORE);
        List labels = Arrays.stream((Enum[])castClass.getEnumConstants()).map(e -> (String)enumConverter.convert((Object)e.name())).collect(Collectors.toList());
        return new WithinSet((Type)Types.TEXT, labels);
    }

    public WithinSet(Type underlyingType, Object ... objects) {
        this(underlyingType, Arrays.asList(objects));
    }

    public WithinSet(Type underlyingType, Collection<?> objects) {
        if (objects.isEmpty()) {
            throw new IllegalArgumentException("member set can not be empty");
        }
        this.underlyingType = underlyingType;
        try {
            this.allowed = ImmutableSet.copyOf((Collection)objects.stream().map(m -> underlyingType.coerce(m)).collect(Collectors.toSet()));
        }
        catch (CoercionException ex) {
            throw new IllegalArgumentException("member set must conform to underlying type", ex);
        }
    }

    @Override
    public Object coerce(Object value) {
        Object coerced = this.underlyingType.coerce(value);
        if (!this.allowed.contains(coerced)) {
            throw new CoercionException(value, (Type)this, "'%s' does not belong to set [%s]", value, this.allowedString());
        }
        return coerced;
    }

    @Override
    public Class<?> internalType() {
        return this.underlyingType.internalType();
    }

    public String allowedString() {
        return JOINER.join(this.allowed);
    }

    public String toString() {
        return String.format("WithinSet(type=%s, allowed=[%s])", this.underlyingType, this.allowedString());
    }

    public boolean equals(Object obj) {
        if (obj instanceof WithinSet) {
            WithinSet rhs = (WithinSet)obj;
            return rhs.underlyingType.equals(this.underlyingType) && rhs.allowed.equals(this.allowed);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.underlyingType, this.allowed});
    }

    @Generated
    public Set<?> getAllowed() {
        return this.allowed;
    }

    @Override
    @Generated
    public Type getUnderlyingType() {
        return this.underlyingType;
    }
}

