/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.Rangeable;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeInformation;
import nz.org.riskscape.engine.types.WrappingType;
import nz.org.riskscape.engine.typexp.AST;
import nz.org.riskscape.engine.typexp.ComplexTypeConstructor;
import nz.org.riskscape.engine.typexp.TypeArgumentException;

public class WithinRange
implements Type,
WrappingType {
    public static final ComplexTypeConstructor TYPE_CONSTRUCTOR = (typeBuilder, type) -> {
        List<AST> args = type.args();
        Type subType = typeBuilder.expectType(args.remove(0), ast -> new TypeArgumentException(type, "First argument must be a type"));
        if (!(subType instanceof Rangeable)) {
            throw new TypeArgumentException(type, "First argument must be a rangeable type, such as a number");
        }
        if (args.size() != 2) {
            throw new TypeArgumentException(type, String.format("Exactly 2 trailing arguments are required, but %d given", args.size()));
        }
        List<Object> coerced = typeBuilder.expectConstantsOfType(type, subType, args, 1);
        return new WithinRange((Rangeable)subType, coerced.remove(0), coerced.remove(0));
    };
    public static final TypeInformation TYPE_INFORMATION = new TypeInformation("range", WithinRange.class, Object.class, TYPE_CONSTRUCTOR);
    private Rangeable underlyingType;
    private Comparable<Object> max;
    private Comparable<Object> min;

    public WithinRange(Rangeable type, Object min, Object max) {
        this.underlyingType = type;
        if (!Comparable.class.isAssignableFrom(this.internalType())) {
            throw new IllegalArgumentException("the internal type of %s does not implement comparable, this is probably a programming error");
        }
        this.min = (Comparable)type.coerce(min);
        this.max = (Comparable)type.coerce(max);
    }

    @Override
    public Object coerce(Object value) {
        this.checkForNull(value);
        Comparable coerced = (Comparable)this.underlyingType.coerce(value);
        if (coerced.compareTo(this.min) < 0) {
            throw new CoercionException(value, (Type)this, "'%s' is less than minimum of %s", value, this.min);
        }
        if (this.max.compareTo(coerced) < 0) {
            throw new CoercionException(value, (Type)this, "'%s' exceeds maximum of %s", value, this.max);
        }
        return coerced;
    }

    @Override
    public Class<?> internalType() {
        return this.underlyingType.internalType();
    }

    public String toString() {
        return String.format("WithinRange(type=%s, min=%s, max=%s)", this.underlyingType, this.min, this.max);
    }

    public boolean equals(Object obj) {
        if (obj instanceof WithinRange) {
            WithinRange rhs = (WithinRange)obj;
            return rhs.underlyingType.equals(this.underlyingType) && rhs.max.equals(this.max) && rhs.min.equals(this.min);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.underlyingType, this.min, this.max);
    }

    @Override
    @Generated
    public Rangeable getUnderlyingType() {
        return this.underlyingType;
    }

    @Generated
    public Comparable<Object> getMax() {
        return this.max;
    }

    @Generated
    public Comparable<Object> getMin() {
        return this.min;
    }
}

