/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.WrappingType;

public class WithMetadata
implements WrappingType {
    private final Type underlyingType;
    private final List<?> metadata;

    public static Type wrap(Type given, Object ... metadata) {
        return Nullable.rewrap(given, underlyingType -> new WithMetadata((Type)underlyingType, Arrays.asList(metadata)));
    }

    public static <T> Optional<T> find(Type type, Class<T> metadataClass) {
        return type.findAllowNull(WithMetadata.class).flatMap(t -> t.getMetadata(metadataClass));
    }

    private WithMetadata(Type wrapped, List<?> metadata) {
        if (wrapped.find(WithMetadata.class).isPresent()) {
            throw new UnsupportedOperationException("Cannot have multiple nested WithMetadata types");
        }
        this.underlyingType = wrapped;
        this.metadata = metadata;
    }

    public <T> Optional<T> getMetadata(Class<T> target) {
        for (Object entry : this.metadata) {
            if (!target.isInstance(entry)) continue;
            return Optional.of(target.cast(entry));
        }
        return Optional.empty();
    }

    @Override
    public Object coerce(Object value) throws CoercionException {
        return this.getUnderlyingType().coerce(value);
    }

    @Override
    public Class<?> internalType() {
        return this.getUnderlyingType().internalType();
    }

    public String toString() {
        return "WithMetadata[" + this.underlyingType.toString() + "]";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WithMetadata)) {
            return false;
        }
        WithMetadata other = (WithMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Type this$underlyingType = this.getUnderlyingType();
        Type other$underlyingType = other.getUnderlyingType();
        if (this$underlyingType == null ? other$underlyingType != null : !this$underlyingType.equals(other$underlyingType)) {
            return false;
        }
        List<?> this$metadata = this.metadata;
        List<?> other$metadata = other.metadata;
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WithMetadata;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $underlyingType = this.getUnderlyingType();
        result = result * 59 + ($underlyingType == null ? 43 : $underlyingType.hashCode());
        List<?> $metadata = this.metadata;
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    @Override
    @Generated
    public Type getUnderlyingType() {
        return this.underlyingType;
    }
}

