/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import nz.org.riskscape.engine.types.Anything;
import nz.org.riskscape.engine.types.Bool;
import nz.org.riskscape.engine.types.Date;
import nz.org.riskscape.engine.types.Decimal;
import nz.org.riskscape.engine.types.Floating;
import nz.org.riskscape.engine.types.Geom;
import nz.org.riskscape.engine.types.GeomType;
import nz.org.riskscape.engine.types.Integer;
import nz.org.riskscape.engine.types.Nothing;
import nz.org.riskscape.engine.types.SimpleType;
import nz.org.riskscape.engine.types.Smallfloat;
import nz.org.riskscape.engine.types.Text;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import org.locationtech.jts.geom.Geometry;

public class Types {
    public static final Text TEXT = SimpleType.getInstance(Text.class);
    public static final Integer INTEGER = SimpleType.getInstance(Integer.class);
    public static final Floating FLOATING = SimpleType.getInstance(Floating.class);
    public static final Smallfloat SMALLFLOAT = SimpleType.getInstance(Smallfloat.class);
    public static final Decimal DECIMAL = SimpleType.getInstance(Decimal.class);
    public static final Anything ANYTHING = SimpleType.getInstance(Anything.class);
    public static final Geom GEOMETRY = SimpleType.getInstance(Geom.class);
    public static final GeomType.Line LINE = SimpleType.getInstance(GeomType.Line.class);
    public static final GeomType.Point POINT = SimpleType.getInstance(GeomType.Point.class);
    public static final GeomType.Polygon POLYGON = SimpleType.getInstance(GeomType.Polygon.class);
    public static final Bool BOOLEAN = SimpleType.getInstance(Bool.class);
    public static final Date DATE = SimpleType.getInstance(Date.class);
    public static final Nothing NOTHING = SimpleType.getInstance(Nothing.class);

    public static Type fromJavaType(Class<?> javaType) {
        Type fromJavaTypeInternal = Types.fromJavaTypeInternal(javaType);
        if (fromJavaTypeInternal == null) {
            throw new RuntimeException("Unmapped type: " + String.valueOf(javaType));
        }
        return fromJavaTypeInternal;
    }

    public static Optional<Type> fromJavaTypeOptional(Class<?> javaType) {
        return Optional.ofNullable(Types.fromJavaTypeInternal(javaType));
    }

    private static Type fromJavaTypeInternal(Class<?> javaType) {
        if (javaType.equals(java.lang.Integer.class) || javaType.equals(java.lang.Integer.TYPE) || javaType.equals(Long.class) || javaType.equals(Long.TYPE) || javaType.equals(Short.class) || javaType.equals(Short.TYPE) || javaType.equals(Byte.class) || javaType.equals(Byte.TYPE)) {
            return INTEGER;
        }
        if (javaType.equals(Boolean.class) || javaType.equals(Boolean.TYPE) || javaType.equals(Boolean.TYPE)) {
            return BOOLEAN;
        }
        if (javaType.equals(String.class)) {
            return TEXT;
        }
        if (Geometry.class.isAssignableFrom(javaType)) {
            return GEOMETRY;
        }
        if (javaType.equals(BigDecimal.class) || javaType.equals(BigInteger.class)) {
            return DECIMAL;
        }
        if (javaType.equals(Double.class) || javaType.equals(Double.TYPE)) {
            return FLOATING;
        }
        if (javaType.equals(Float.class) || javaType.equals(Float.TYPE)) {
            return FLOATING;
        }
        if (java.util.Date.class.isAssignableFrom(javaType)) {
            return DATE;
        }
        return null;
    }

    public static Optional<Type> fromStrictJavaTypeOptional(Class<?> javaType) {
        SimpleType found = javaType.equals(Long.class) ? INTEGER : (javaType.equals(Boolean.class) ? BOOLEAN : (javaType.equals(String.class) ? TEXT : (Geometry.class.isAssignableFrom(javaType) ? GEOMETRY : (javaType.equals(BigDecimal.class) ? DECIMAL : (javaType.equals(Double.class) ? FLOATING : (java.util.Date.class.isAssignableFrom(javaType) ? DATE : null))))));
        return Optional.ofNullable(found);
    }

    public static <T extends Type> T findOrThrow(Object context, T wanted, Type actual) throws ProblemException {
        return (T)((Type)actual.find(wanted.getClass()).orElseThrow(() -> new ProblemException((Problems)TypeProblems.get().mismatch(context, wanted, actual))));
    }
}

