/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.util.Pair;

public interface TypeVisitor<T, U> {
    public static final Object NO_META = new Object();

    public static <T> T bfs(Type root, T visitData, final BiConsumer<T, Type> consumer) {
        root.visit(new TypeVisitor<T, Void>(){

            @Override
            public Void atomicType(Type atomicType, T data) {
                consumer.accept(data, atomicType);
                return null;
            }

            @Override
            public Void compoundType(Type compoundType, List<Pair<Type, ?>> children, T data) {
                consumer.accept(data, compoundType);
                for (Pair<Type, ?> pair : children) {
                    pair.getLeft().visit(this, data);
                }
                return null;
            }
        }, visitData);
        return visitData;
    }

    public static List<Pair<Type, ?>> children(Type type0) {
        return TypeVisitor.children(type0, NO_META);
    }

    public static List<Pair<Type, ?>> children(Type type0, Object meta0) {
        return Arrays.asList(Pair.of(type0, meta0));
    }

    public static List<Pair<Type, ?>> children(Type type0, Type type1) {
        return TypeVisitor.children(type0, NO_META, type1, NO_META);
    }

    public static List<Pair<Type, ?>> children(Type type0, Object meta0, Type type1, Object meta1) {
        return Arrays.asList(Pair.of(type0, meta0), Pair.of(type1, meta1));
    }

    public U atomicType(Type var1, T var2);

    public U compoundType(Type var1, List<Pair<Type, ?>> var2, T var3);
}

