/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.IdentifiedCollection;
import nz.org.riskscape.engine.types.Anything;
import nz.org.riskscape.engine.types.Bool;
import nz.org.riskscape.engine.types.CoverageType;
import nz.org.riskscape.engine.types.Date;
import nz.org.riskscape.engine.types.Decimal;
import nz.org.riskscape.engine.types.Enumeration;
import nz.org.riskscape.engine.types.Floating;
import nz.org.riskscape.engine.types.Geom;
import nz.org.riskscape.engine.types.GeomType;
import nz.org.riskscape.engine.types.Integer;
import nz.org.riskscape.engine.types.JavaRule;
import nz.org.riskscape.engine.types.LambdaType;
import nz.org.riskscape.engine.types.MultiGeom;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.RelationType;
import nz.org.riskscape.engine.types.SimpleType;
import nz.org.riskscape.engine.types.Smallfloat;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Text;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeInformation;
import nz.org.riskscape.engine.types.WithinRange;
import nz.org.riskscape.engine.types.WithinSet;
import nz.org.riskscape.engine.types.ancestor.AncestorRule;
import nz.org.riskscape.engine.types.ancestor.NullableAncestorRule;
import nz.org.riskscape.engine.types.ancestor.NumberTypeAncestorRule;
import nz.org.riskscape.engine.types.ancestor.RSListAncestorRule;
import nz.org.riskscape.engine.types.ancestor.ReferencedAncestorRule;
import nz.org.riskscape.engine.types.ancestor.StructMemberAncestorRule;
import nz.org.riskscape.engine.types.ancestor.WrappedTypeAncestorRule;
import nz.org.riskscape.engine.types.eqrule.EquivalenceRule;
import nz.org.riskscape.engine.types.eqrule.NullableRule;
import nz.org.riskscape.engine.types.eqrule.NumberToFloatingRule;
import nz.org.riskscape.engine.types.eqrule.PartialStructRule;
import nz.org.riskscape.engine.types.eqrule.SingleGeomToMultiGeomRule;
import nz.org.riskscape.engine.types.eqrule.SingleValueStructRule;
import nz.org.riskscape.engine.types.eqrule.StructGeometryRule;
import nz.org.riskscape.engine.types.varule.AnythingRule;
import nz.org.riskscape.engine.types.varule.ContainingTypeRule;
import nz.org.riskscape.engine.types.varule.EmptyListRule;
import nz.org.riskscape.engine.types.varule.EqualityRule;
import nz.org.riskscape.engine.types.varule.GeometryRule;
import nz.org.riskscape.engine.types.varule.LinkedTypeRule;
import nz.org.riskscape.engine.types.varule.LookupTableTypeRule;
import nz.org.riskscape.engine.types.varule.NothingRule;
import nz.org.riskscape.engine.types.varule.NullableTargetRule;
import nz.org.riskscape.engine.types.varule.SameRule;
import nz.org.riskscape.engine.types.varule.VarianceRule;
import nz.org.riskscape.engine.types.varule.WrappingTypesRule;

public class TypeRegistry
extends IdentifiedCollection.Base<TypeInformation> {
    private final List<EquivalenceRule> equivalenceRules = new ArrayList<EquivalenceRule>();
    private final List<VarianceRule> varianceRules = new ArrayList<VarianceRule>();
    private final List<AncestorRule> ancestorRules = new ArrayList<AncestorRule>();

    public static TypeRegistry withDefaults() {
        return TypeRegistry.addDefaults(new TypeRegistry());
    }

    public static TypeRegistry addDefaults(TypeRegistry registry) {
        registry.add(SimpleType.getTypeInformation(Integer.class));
        registry.add(SimpleType.getTypeInformation(Bool.class));
        registry.add(SimpleType.getTypeInformation(Date.class));
        registry.add(SimpleType.getTypeInformation(Text.class));
        registry.add(SimpleType.getTypeInformation(Floating.class));
        registry.add(SimpleType.getTypeInformation(Smallfloat.class));
        registry.add(SimpleType.getTypeInformation(Decimal.class));
        registry.add(SimpleType.getTypeInformation(Geom.class));
        registry.add(SimpleType.getTypeInformation(Anything.class));
        registry.add(SimpleType.getTypeInformation(GeomType.Line.class));
        registry.add(SimpleType.getTypeInformation(GeomType.Point.class));
        registry.add(SimpleType.getTypeInformation(GeomType.Polygon.class));
        registry.add(MultiGeom.MULTI_LINE_TYPE_INFORMATION);
        registry.add(MultiGeom.MULTI_POINT_TYPE_INFORMATION);
        registry.add(MultiGeom.MULTI_POLYGON_TYPE_INFORMATION);
        registry.add(Struct.TYPE_INFORMATION);
        registry.add(WithinSet.TYPE_INFORMATION);
        registry.add(WithinRange.TYPE_INFORMATION);
        registry.add(Enumeration.TYPE_INFORMATION);
        registry.add(Nullable.TYPE_INFORMATION);
        registry.add(RSList.TYPE_INFORMATION);
        registry.add(CoverageType.TYPE_INFORMATION);
        registry.add(RelationType.TYPE_INFORMATION);
        registry.add(LambdaType.TYPE_INFORMATION);
        TypeRegistry.addDefaultVarianceRules(registry);
        TypeRegistry.addDefaultAncestorRules(registry);
        registry.addEquivalenceRule(new NullableRule());
        registry.addEquivalenceRule(new NumberToFloatingRule());
        registry.addEquivalenceRule(new SingleValueStructRule());
        registry.addEquivalenceRule(new PartialStructRule());
        registry.addEquivalenceRule(new SingleGeomToMultiGeomRule());
        registry.addEquivalenceRule(new StructGeometryRule());
        return registry;
    }

    public static TypeRegistry addDefaultVarianceRules(TypeRegistry registry) {
        registry.addVarianceRule(new SameRule());
        registry.addVarianceRule(new NothingRule());
        registry.addVarianceRule(new JavaRule());
        registry.addVarianceRule(new NullableTargetRule());
        registry.addVarianceRule(new EmptyListRule());
        registry.addVarianceRule(new EqualityRule());
        registry.addVarianceRule(new AnythingRule());
        registry.addVarianceRule(new LinkedTypeRule());
        registry.addVarianceRule(new WrappingTypesRule());
        registry.addVarianceRule(new ContainingTypeRule());
        registry.addVarianceRule(new LookupTableTypeRule());
        registry.addVarianceRule(new GeometryRule());
        return registry;
    }

    public static TypeRegistry addDefaultAncestorRules(TypeRegistry registry) {
        registry.addAncestorRule(new NullableAncestorRule());
        registry.addAncestorRule(new StructMemberAncestorRule());
        registry.addAncestorRule(new RSListAncestorRule());
        registry.addAncestorRule(new ReferencedAncestorRule());
        registry.addAncestorRule(new WrappedTypeAncestorRule());
        registry.addAncestorRule(new NumberTypeAncestorRule());
        return registry;
    }

    public void addEquivalenceRule(EquivalenceRule rule) {
        this.equivalenceRules.add(rule);
    }

    public void addVarianceRule(VarianceRule rule) {
        this.varianceRules.add(rule);
    }

    private void addAncestorRule(AncestorRule rule) {
        this.ancestorRules.add(rule);
    }

    public Optional<TypeInformation> findTypeInformation(Type someType) {
        return this.findTypeInformation(someType.getClass());
    }

    public Optional<TypeInformation> findTypeInformation(Class<? extends Type> someTypeClass) {
        for (TypeInformation info : this.getAll()) {
            if (!info.getTypeClass().equals(someTypeClass)) continue;
            return Optional.of(info);
        }
        return Optional.empty();
    }

    @Generated
    public List<EquivalenceRule> getEquivalenceRules() {
        return this.equivalenceRules;
    }

    @Generated
    public List<VarianceRule> getVarianceRules() {
        return this.varianceRules;
    }

    @Generated
    public List<AncestorRule> getAncestorRules() {
        return this.ancestorRules;
    }
}

