/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.TypeVisitor;
import nz.org.riskscape.engine.types.WrappingType;
import nz.org.riskscape.engine.typeset.LinkedType;
import nz.org.riskscape.util.ListUtils;

public interface Type {
    public Object coerce(Object var1) throws CoercionException;

    public Class<?> internalType();

    default public boolean isNumeric() {
        return Number.class.isAssignableFrom(this.internalType());
    }

    default public void checkForNull(Object value) {
        if (value == null) {
            throw new CoercionException(value, this, "null is not a valid value for type " + this.toString(), new Object[0]);
        }
    }

    default public Type getUnwrappedType() {
        if (this instanceof WrappingType) {
            return ((WrappingType)this).getUnderlyingType().getUnwrappedType();
        }
        return this;
    }

    default public <T extends Type> Optional<T> find(Class<T> type) {
        if (this.isA(type)) {
            return Optional.of((Type)type.cast(this));
        }
        if (this instanceof WrappingType) {
            WrappingType wthis = (WrappingType)this;
            return wthis.getUnderlyingType().find(type);
        }
        if (this instanceof LinkedType) {
            LinkedType linkedType = (LinkedType)this;
            return linkedType.getUnderlyingType().find(type);
        }
        return Optional.empty();
    }

    default public <T extends Type> Optional<T> findAllowNull(Class<T> type) {
        return Nullable.strip(this).find(type);
    }

    default public <T extends Type> boolean isA(Class<T> type) {
        return this.getClass().equals(type) || type.isInterface() && type.isInstance(this);
    }

    default public boolean isWrapped() {
        return this != this.getUnwrappedType();
    }

    public Struct asStruct();

    public int estimateSize(Object var1);

    public void toBytes(DataOutputStream var1, Object var2) throws IOException;

    public Object fromBytes(DataInputStream var1) throws IOException;

    default public boolean isNullable() {
        return false;
    }

    default public String toString(Object value) {
        return Objects.toString(value);
    }

    default public List<Type> unwrap() {
        if (this instanceof WrappingType) {
            WrappingType wt = (WrappingType)this;
            return ListUtils.prepend(this, wt.getUnderlyingType().unwrap());
        }
        return Collections.singletonList(this);
    }

    public <T, U> U visit(TypeVisitor<T, U> var1, T var2);
}

