/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import nz.org.riskscape.engine.types.SimpleType;

public class Text
extends SimpleType {
    public static final Charset IO_CHARSET = Charset.forName("UTF-8");
    private static final int HOUSEKEEPING_BYTES = 2;

    @Override
    public Object coerce(Object value) {
        this.checkForNull(value);
        return value.toString();
    }

    @Override
    public Class<?> internalType() {
        return String.class;
    }

    @Override
    public int estimateSize(Object entry) {
        String string = (String)entry;
        return 2 + string.length() * 2;
    }

    @Override
    public void toBytes(DataOutputStream os, Object toWrite) throws IOException {
        String stringToWrite = (String)toWrite;
        byte[] utf8Bytes = stringToWrite.getBytes(IO_CHARSET);
        os.writeShort(utf8Bytes.length);
        os.write(utf8Bytes);
    }

    @Override
    public Object fromBytes(DataInputStream in) throws IOException {
        int read;
        int expectedLength = in.readShort();
        byte[] utf8Bytes = new byte[expectedLength];
        for (int totalRead = 0; totalRead != expectedLength; totalRead += read) {
            read = in.read(utf8Bytes, totalRead, expectedLength - totalRead);
            if (read != -1) continue;
            throw new EOFException("unexpected EOF reading text");
        }
        return new String(utf8Bytes, IO_CHARSET);
    }

    @Override
    public Object read(ByteBuffer buffer) {
        int byteLength = buffer.getInt();
        byte[] bytes = new byte[byteLength];
        buffer.get(bytes);
        return new String(bytes, IO_CHARSET);
    }

    @Override
    public void write(ByteBuffer buffer, Object value) {
        String string = (String)value;
        byte[] bytes = string.getBytes(IO_CHARSET);
        buffer.putInt(bytes.length);
        buffer.put(bytes);
    }
}

