/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.data.InputDataProblems;
import nz.org.riskscape.engine.query.TupleUtils;
import nz.org.riskscape.engine.relation.UnexpectedNullValueException;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.DuplicateKeysException;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeInformation;
import nz.org.riskscape.engine.types.TypeVisitor;
import nz.org.riskscape.engine.typexp.AST;
import nz.org.riskscape.engine.typexp.TypeArgumentException;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.ExpressionProblems;

public class Struct
implements Type {
    public static final Class<?> INTERNAL_TYPE = Tuple.class;
    public static final TypeInformation TYPE_INFORMATION = new TypeInformation("struct", Struct.class, Tuple.class, (typeBuilder, type) -> {
        List<AST> args = type.args();
        if (args.size() != 1) {
            throw new TypeArgumentException(type, "one argument expected");
        }
        AST.Dictionary dict = typeBuilder.expectAST(AST.Dictionary.class, args.remove(0), ast -> new TypeArgumentException(type, "argument must be a dictionary"));
        StructBuilder builder = new StructBuilder();
        Set<Map.Entry<AST.Symbol, AST>> entrySet = dict.values.entrySet();
        for (Map.Entry<AST.Symbol, AST> entry : entrySet) {
            Type memberType = typeBuilder.expectType(entry.getValue(), ast -> new TypeArgumentException(type, "dictionary values must be types"));
            builder.add(entry.getKey().ident(), memberType);
        }
        return builder.build();
    });
    public static final Struct EMPTY_STRUCT = new StructBuilder().build();
    private final List<StructMember> members;
    private final Map<String, StructMember> membersMap;

    public static Struct of() {
        return EMPTY_STRUCT;
    }

    public static Struct of(String key, Type type) {
        return new StructBuilder().add(key, type).build();
    }

    public static Struct of(String k0, Type t0, String k1, Type t1) {
        return new StructBuilder().add(k0, t0).add(k1, t1).build();
    }

    public static Struct of(String k0, Type t0, String k1, Type t1, String k2, Type t2) {
        return new StructBuilder().add(k0, t0).add(k1, t1).add(k2, t2).build();
    }

    public static Struct of(String k0, Type t0, String k1, Type t1, String k2, Type t2, String k3, Type t3) {
        return new StructBuilder().add(k0, t0).add(k1, t1).add(k2, t2).add(k3, t3).build();
    }

    public static Struct of(String k0, Type t0, String k1, Type t1, String k2, Type t2, String k3, Type t3, String k4, Type t4) {
        return new StructBuilder().add(k0, t0).add(k1, t1).add(k2, t2).add(k3, t3).add(k4, t4).build();
    }

    public static StructBuilder builder() {
        return new StructBuilder();
    }

    public static List<String> flattenMemberKeys(Struct struct) {
        LinkedList<String> names = new LinkedList<String>();
        Struct.flattenMemberKeys(names, "", struct);
        return names;
    }

    private static void flattenMemberKeys(List<String> appendTo, String prefix, Struct struct) {
        for (StructMember member : struct.getMembers()) {
            Struct unwrapped = member.getType().findAllowNull(Struct.class).orElse(null);
            String name = prefix + member.getKey();
            if (unwrapped != null) {
                Struct.flattenMemberKeys(appendTo, name + ".", unwrapped);
                continue;
            }
            appendTo.add(name);
        }
    }

    private Struct(List<StructMember> members) {
        this.members = members;
        this.membersMap = new HashMap<String, StructMember>(members.size());
        HashSet<StructMember> collisions = new HashSet<StructMember>();
        for (StructMember member : members) {
            StructMember replaced = this.membersMap.put(member.key, member);
            if (replaced != null) {
                collisions.add(member);
                collisions.add(replaced);
            }
            assert (member.owner == null) : "Members can not be reused, create a new one";
            member.owner = this;
        }
        if (!collisions.isEmpty()) {
            throw new DuplicateKeysException(collisions);
        }
    }

    public List<String> getMemberKeys() {
        ArrayList<String> keys = new ArrayList<String>(this.membersMap.size());
        keys.addAll(this.membersMap.keySet());
        Collections.sort(keys);
        return keys;
    }

    public List<StructMember> getMembers() {
        return Collections.unmodifiableList(this.members);
    }

    @Override
    public Object coerce(Object value) {
        if (value instanceof Tuple && ((Tuple)value).getStruct() == this) {
            return value;
        }
        if (value instanceof Map) {
            Map sourceTuple = (Map)value;
            return Tuple.coerce(this, sourceTuple, EnumSet.of(Tuple.CoerceOptions.SURPLUS_IGNORED));
        }
        if (value instanceof Tuple) {
            Tuple tuple = (Tuple)value;
            return Tuple.coerce(this, tuple.toMap(), EnumSet.of(Tuple.CoerceOptions.SURPLUS_IGNORED));
        }
        if (this.members.size() == 1) {
            StructMember m = this.members.get(0);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(m.key, m.type.coerce(value));
            return Tuple.coerce(this, map, EnumSet.of(Tuple.CoerceOptions.MISSING_IGNORED));
        }
        throw new CoercionException(value, this);
    }

    @Override
    public Class<?> internalType() {
        return INTERNAL_TYPE;
    }

    @Deprecated
    public Struct build() {
        return this;
    }

    public String toString() {
        return this.members.stream().map(se -> String.format("%s=>%s", se.key, se.type)).collect(Collectors.joining(", ", "{", "}"));
    }

    public Optional<StructMember> getMember(String key) {
        return Optional.ofNullable(this.membersMap.get(key));
    }

    public StructMember getEntry(String key) {
        return this.membersMap.get(key);
    }

    public Struct parent(String asKey) {
        return Struct.of(asKey, this).build();
    }

    public Struct add(String asKey, Type otherType) {
        ArrayList<StructMember> newMembers = new ArrayList<StructMember>(this.size() + 1);
        for (StructMember member : this.members) {
            newMembers.add(member.clone());
        }
        newMembers.add(new StructMember(asKey, otherType, this.size()));
        return new Struct(newMembers);
    }

    public ResultOrProblems<Struct> remove(List<String> toRemove) {
        ArrayList<String> stillToRemove = new ArrayList<String>(toRemove);
        ArrayList<StructMember> newMembers = new ArrayList<StructMember>(this.size());
        int count = 0;
        for (StructMember member : this.members) {
            if (!stillToRemove.contains(member.key)) {
                newMembers.add(new StructMember(member.key, member.type, count));
                ++count;
                continue;
            }
            stillToRemove.remove(member.key);
        }
        if (!stillToRemove.isEmpty()) {
            return ResultOrProblems.of(new Struct(newMembers), stillToRemove.stream().map(key -> ExpressionProblems.get().noSuchStructMember((String)key, this.getMemberKeys())).toList());
        }
        return ResultOrProblems.of(new Struct(newMembers));
    }

    public Struct replace(String key, Type newType) {
        ArrayList<StructMember> newMembers = new ArrayList<StructMember>(this.size());
        boolean replaced = false;
        int count = 0;
        for (StructMember member : this.members) {
            Type type;
            if (member.getKey().equals(key)) {
                type = newType;
                replaced = true;
            } else {
                type = member.getType();
            }
            newMembers.add(new StructMember(member.getKey(), type, count));
            ++count;
        }
        if (!replaced) {
            throw new IllegalArgumentException(String.format("This struct does not contain a member with key %s, has %s", key, this.members));
        }
        return new Struct(newMembers);
    }

    public Struct and(Struct struct) {
        return Struct.builder().addAll(this).addAll(struct).build();
    }

    public Struct and(String newKey, Type newType) {
        return this.add(newKey, newType);
    }

    @Override
    public Struct asStruct() {
        return this;
    }

    public int size() {
        return this.members.size();
    }

    public boolean contains(StructMember entry) {
        return this.members.contains(entry);
    }

    public boolean isUnion(Struct rhs) {
        return this.members.stream().map(StructMember::getType).collect(Collectors.toList()).equals(rhs.members.stream().map(StructMember::getType).collect(Collectors.toList()));
    }

    public boolean isEquivalent(Struct rhs) {
        return this.members.stream().map(se -> Arrays.asList(se.key, se.type)).collect(Collectors.toSet()).equals(rhs.members.stream().map(se -> Arrays.asList(se.key, se.type)).collect(Collectors.toSet()));
    }

    public boolean isSupersetOf(Struct rhs) {
        throw new RuntimeException("not yet implemented");
    }

    public boolean hasMember(String key) {
        return this.membersMap.containsKey(key);
    }

    public int hashCode() {
        return this.members.hashCode();
    }

    public boolean equals(Object rhs) {
        if (rhs instanceof Struct) {
            Struct rhsStruct = (Struct)rhs;
            return this.members.equals(rhsStruct.members);
        }
        return false;
    }

    @Override
    public int estimateSize(Object entry) {
        if (entry instanceof Tuple) {
            Tuple tuple = (Tuple)entry;
            return tuple.estimateSize();
        }
        return 0;
    }

    @Override
    public void toBytes(DataOutputStream os, Object toWrite) throws IOException {
        Tuple value = (Tuple)toWrite;
        assert (value.getStruct().equals(this));
        for (StructMember member : this.members) {
            Object valueToWrite = value.fetch(member);
            if (valueToWrite == null && !member.type.isNullable()) {
                throw new UnexpectedNullValueException(InputDataProblems.get().unexpectedNullValue(member.key, TupleUtils.getContentSummary(value)));
            }
            member.type.toBytes(os, valueToWrite);
        }
    }

    @Override
    public Object fromBytes(DataInputStream in) throws IOException {
        Tuple tuple = new Tuple(this);
        for (StructMember member : this.members) {
            Object read = member.type.fromBytes(in);
            tuple.set(member, read);
        }
        return tuple;
    }

    public Struct addOrReplace(String key, Type type) {
        if (this.hasMember(key)) {
            return this.replace(key, type);
        }
        return this.add(key, type);
    }

    @Override
    public <T, U> U visit(TypeVisitor<T, U> tv, T data) {
        Function<StructMember, Pair> toPair = m -> Pair.of(m.getType(), m.getKey());
        return tv.compoundType(this, this.members.stream().map(toPair).toList(), data);
    }

    public static class StructBuilder {
        private final List<StructMember> pairs;

        public StructBuilder() {
            this.pairs = new ArrayList<StructMember>();
        }

        public StructBuilder(int expectedSize) {
            this.pairs = new ArrayList<StructMember>(expectedSize);
        }

        @Deprecated
        public StructBuilder and(String key, Type type) {
            return this.add(key, type);
        }

        public StructBuilder add(String key, Type type) {
            this.pairs.add(new StructMember(key, type, this.pairs.size()));
            return this;
        }

        public StructBuilder addAll(Struct type) {
            for (StructMember member : type.members) {
                this.pairs.add(new StructMember(member.key, member.type, this.pairs.size()));
            }
            return this;
        }

        public ResultOrProblems<Struct> buildOr() {
            ArrayList<StructMember> memberList = new ArrayList<StructMember>(this.pairs.size());
            for (StructMember member : this.pairs) {
                memberList.add(member.clone());
            }
            try {
                return ResultOrProblems.of(new Struct(memberList));
            }
            catch (DuplicateKeysException ex) {
                return ResultOrProblems.error(ex);
            }
        }

        public Struct build() {
            ArrayList<StructMember> members = new ArrayList<StructMember>(this.pairs.size());
            for (StructMember member : this.pairs) {
                members.add(member.clone());
            }
            return new Struct(members);
        }

        public boolean isEmpty() {
            return this.pairs.isEmpty();
        }

        public int size() {
            return this.pairs.size();
        }
    }

    public static final class StructMember {
        @NonNull
        final String key;
        @NonNull
        final Type type;
        final int index;
        Struct owner;

        public StructMember clone() {
            return new StructMember(this.key, this.type, this.index);
        }

        @NonNull
        @Generated
        public String getKey() {
            return this.key;
        }

        @NonNull
        @Generated
        public Type getType() {
            return this.type;
        }

        @Generated
        public int getIndex() {
            return this.index;
        }

        @Generated
        public Struct getOwner() {
            return this.owner;
        }

        @Generated
        public void setOwner(Struct owner) {
            this.owner = owner;
        }

        @Generated
        public StructMember(@NonNull String key, @NonNull Type type, int index) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.key = key;
            this.type = type;
            this.index = index;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StructMember)) {
                return false;
            }
            StructMember other = (StructMember)o;
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            Type this$type = this.getType();
            Type other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndex();
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Struct.StructMember(key=" + this.getKey() + ", type=" + String.valueOf(this.getType()) + ", index=" + this.getIndex() + ")";
        }
    }
}

