/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.Rangeable;
import nz.org.riskscape.engine.types.SimpleType;
import nz.org.riskscape.engine.types.Type;

public class Smallfloat
extends SimpleType
implements Rangeable {
    @Override
    public Object coerce(Object value) throws CoercionException {
        this.checkForNull(value);
        if (value instanceof Number) {
            Number number = (Number)value;
            return Float.valueOf(number.floatValue());
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Float.valueOf(new BigDecimal(string).floatValue());
            }
            catch (NumberFormatException ex) {
                throw new CoercionException(value, (Type)this, ex, "Failed to parse number from '%s'", value);
            }
        }
        throw new CoercionException(value, this);
    }

    @Override
    public Class<?> internalType() {
        return Float.class;
    }

    @Override
    public int estimateSize(Object entry) {
        return 4;
    }

    @Override
    public void toBytes(DataOutputStream os, Object toWrite) throws IOException {
        os.writeFloat(((Float)toWrite).floatValue());
    }

    @Override
    public Object fromBytes(DataInputStream in) throws IOException {
        return Float.valueOf(in.readFloat());
    }

    @Override
    public void write(ByteBuffer buffer, Object value) {
        buffer.putFloat(((Float)value).floatValue());
    }

    @Override
    public Object read(ByteBuffer buffer) {
        return Float.valueOf(buffer.getFloat());
    }
}

