/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeVisitor;

public class ScopedLambdaType
implements Type {
    private final Struct scopedAsStruct = Struct.of("value", this);
    private final Struct scopeType;
    private final List<String> args;

    public ScopedLambdaType(Struct struct, String ... args) {
        this(struct, Arrays.asList(args));
    }

    public int getArity() {
        return this.args.size();
    }

    @Override
    public Struct asStruct() {
        return this.scopedAsStruct;
    }

    @Override
    public Object coerce(Object value) throws CoercionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<?> internalType() {
        return Object.class;
    }

    @Override
    public int estimateSize(Object entry) {
        return -1;
    }

    @Override
    public void toBytes(DataOutputStream os, Object toWrite) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object fromBytes(DataInputStream in) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ScopedLambdaType) {
            ScopedLambdaType rhs = (ScopedLambdaType)obj;
            return rhs.scopeType.equals(this.scopeType) && rhs.getArgs().equals(this.getArgs());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.scopeType, this.args);
    }

    public String toString() {
        return String.format("\u03bb-Scoped(%s, scope=%s)", this.args.stream().collect(Collectors.joining(",")), this.scopeType);
    }

    @Override
    public <T, U> U visit(TypeVisitor<T, U> tv, T data) {
        return tv.compoundType(this, TypeVisitor.children(this.scopeType), data);
    }

    public Struct buildCallingScopeType(Type ... lambdaArgTypes) {
        Struct newScopeType = this.scopeType;
        for (int i = 0; i < lambdaArgTypes.length; ++i) {
            String lambdaArgName = this.args.get(i);
            newScopeType = newScopeType.addOrReplace(lambdaArgName, lambdaArgTypes[i]);
        }
        return newScopeType;
    }

    @Generated
    public ScopedLambdaType(Struct scopeType, List<String> args) {
        this.scopeType = scopeType;
        this.args = args;
    }

    @Generated
    public Struct getScopeType() {
        return this.scopeType;
    }

    @Generated
    public List<String> getArgs() {
        return this.args;
    }
}

