/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.ContainingType;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeInformation;
import nz.org.riskscape.engine.typexp.AST;
import nz.org.riskscape.engine.typexp.ComplexTypeConstructor;
import nz.org.riskscape.engine.typexp.TypeArgumentException;

public class RelationType
implements Type,
ContainingType {
    public static final ComplexTypeConstructor TYPE_CONSTRUCTOR = (typeBuilder, type) -> {
        List<AST> args = type.args();
        if (args.size() != 1) {
            throw new TypeArgumentException(type, "single argument expected");
        }
        Type subType = typeBuilder.expectType(args.get(0), ast -> new TypeArgumentException(type, "expected a type"));
        Struct asStruct = subType.find(Struct.class).orElseThrow(() -> new TypeArgumentException(type, "expected a struct type"));
        return new RelationType(asStruct);
    };
    public static final TypeInformation TYPE_INFORMATION = new TypeInformation("relation", RelationType.class, Relation.class, TYPE_CONSTRUCTOR);
    public static final RelationType WILD = new RelationType(Struct.EMPTY_STRUCT);
    private final Struct memberType;

    public RelationType(Struct memberType) {
        this.memberType = memberType;
    }

    @Override
    public Object coerce(Object value) throws CoercionException {
        this.checkForNull(value);
        if (value instanceof Relation) {
            Relation relation = (Relation)value;
            if (relation.getType().equals(this.memberType)) {
                return value;
            }
            throw new CoercionException(value, (Type)this, "Given relations's member type does not match - %s != %s", relation.getType(), this.memberType);
        }
        throw new CoercionException(value, (Type)this, "Can not coerce object of type %s", value.getClass());
    }

    @Override
    public Class<?> internalType() {
        return Relation.class;
    }

    @Override
    public Struct asStruct() {
        return Struct.of("value", this);
    }

    @Override
    public int estimateSize(Object entry) {
        return -1;
    }

    @Override
    public void toBytes(DataOutputStream os, Object toWrite) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object fromBytes(DataInputStream in) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RelationType) {
            return ((RelationType)obj).memberType.equals(this.memberType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash("relation", this.memberType);
    }

    public String toString() {
        return String.format("Relation[%s]", this.memberType);
    }

    @Override
    public Type getContainedType() {
        return this.memberType;
    }

    @Generated
    public Struct getMemberType() {
        return this.memberType;
    }
}

