/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import lombok.Generated;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.WrappingType;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Envelope;

public class Referenced
implements WrappingType {
    private final Type underlyingType;
    private final CoordinateReferenceSystem crs;
    private final Envelope envelope;

    public static Type ofNullable(Type underlying, CoordinateReferenceSystem crs) {
        return Nullable.rewrap(underlying, nn -> new Referenced((Type)nn, crs, null));
    }

    public static Type ofNullable(Type underlying, ReferencedEnvelope bounds) {
        return Nullable.rewrap(underlying, nn -> new Referenced((Type)nn, bounds.getCoordinateReferenceSystem(), bounds.copy()));
    }

    public static Type ofNullable(Type underlying, CoordinateReferenceSystem crs, Envelope envelope) {
        return Nullable.rewrap(underlying, nn -> new Referenced((Type)nn, crs, envelope));
    }

    public static Type of(Type underlying, CoordinateReferenceSystem crs, Envelope envelope) {
        return new Referenced(underlying, crs, envelope);
    }

    public static Type of(Type underlying, CoordinateReferenceSystem crs) {
        return new Referenced(underlying, crs);
    }

    public Referenced(Type underlying, ReferencedEnvelope envelope) {
        this(underlying, envelope.getCoordinateReferenceSystem(), (Envelope)envelope);
    }

    public Referenced(Type underlying, CoordinateReferenceSystem crs) {
        this(underlying, crs, null);
    }

    public Referenced(Type underlying, CoordinateReferenceSystem crs, Envelope envelope) {
        if (Nullable.is(underlying)) {
            throw new IllegalArgumentException("can not wrap a nullabe type in underlying - use Nullable#apply");
        }
        if (underlying.find(Referenced.class).isPresent()) {
            throw new IllegalArgumentException("Can not wrap an already referenced type");
        }
        if (crs == null) {
            throw new NullPointerException("CRS can not be null");
        }
        this.underlyingType = underlying;
        this.crs = crs;
        this.envelope = envelope;
    }

    public ReferencedEnvelope getBounds() {
        return this.envelope == null ? null : new ReferencedEnvelope(this.envelope, this.crs);
    }

    @Override
    public Object coerce(Object value) throws CoercionException {
        return this.getUnderlyingType().coerce(value);
    }

    @Override
    public Class<?> internalType() {
        return this.getUnderlyingType().internalType();
    }

    public Type wrapNullable(Type toWrap) {
        return Referenced.ofNullable(toWrap, this.crs, this.envelope);
    }

    public Referenced wrap(Type toWrap) {
        return new Referenced(toWrap, this.crs, this.envelope);
    }

    public String toString() {
        String crsCode = null;
        try {
            crsCode = CRS.lookupIdentifier((IdentifiedObject)this.crs, (boolean)false);
        }
        catch (FactoryException factoryException) {
            // empty catch block
        }
        return String.format("%s[crs=%s]", this.underlyingType, crsCode != null ? crsCode : this.crs.toWKT());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Referenced)) {
            return false;
        }
        Referenced other = (Referenced)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Type this$underlyingType = this.getUnderlyingType();
        Type other$underlyingType = other.getUnderlyingType();
        if (this$underlyingType == null ? other$underlyingType != null : !this$underlyingType.equals(other$underlyingType)) {
            return false;
        }
        CoordinateReferenceSystem this$crs = this.getCrs();
        CoordinateReferenceSystem other$crs = other.getCrs();
        if (this$crs == null ? other$crs != null : !this$crs.equals(other$crs)) {
            return false;
        }
        Envelope this$envelope = this.getEnvelope();
        Envelope other$envelope = other.getEnvelope();
        return !(this$envelope == null ? other$envelope != null : !this$envelope.equals(other$envelope));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Referenced;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $underlyingType = this.getUnderlyingType();
        result = result * 59 + ($underlyingType == null ? 43 : $underlyingType.hashCode());
        CoordinateReferenceSystem $crs = this.getCrs();
        result = result * 59 + ($crs == null ? 43 : $crs.hashCode());
        Envelope $envelope = this.getEnvelope();
        result = result * 59 + ($envelope == null ? 43 : $envelope.hashCode());
        return result;
    }

    @Override
    @Generated
    public Type getUnderlyingType() {
        return this.underlyingType;
    }

    @Generated
    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    @Generated
    public Envelope getEnvelope() {
        return this.envelope;
    }
}

