/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import com.google.common.collect.Lists;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Chars;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.ContainingType;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeInformation;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.typexp.AST;
import nz.org.riskscape.engine.typexp.ComplexTypeConstructor;
import nz.org.riskscape.engine.typexp.TypeArgumentException;

public class RSList
implements Type,
ContainingType {
    private static final List<RSList> INSTANCES = Arrays.asList(new RSList(Types.ANYTHING, false), new RSList(Nullable.ANYTHING, false), new RSList(Types.INTEGER, false), new RSList(Types.FLOATING, false), new RSList(Types.TEXT, false), new RSList(Types.GEOMETRY, false));
    public static final RSList LIST_ANYTHING = RSList.create(Nullable.ANYTHING);
    public static final ComplexTypeConstructor TYPE_CONSTRUCTOR = (typeBuilder, type) -> {
        List<AST> args = type.args();
        if (args.size() != 1) {
            throw new TypeArgumentException(type, "one argument expected");
        }
        Type subType = typeBuilder.expectType(args.get(0), ast -> new TypeArgumentException(type, "list expects a type argument"));
        return RSList.create(subType);
    };
    public static final TypeInformation TYPE_INFORMATION = new TypeInformation("list", RSList.class, List.class, TYPE_CONSTRUCTOR);
    private final Type memberType;

    public static RSList create(Type memberType) {
        for (RSList rsList : INSTANCES) {
            if (!rsList.getMemberType().equals(memberType)) continue;
            return rsList;
        }
        return new RSList(memberType, true);
    }

    @Deprecated
    public RSList(Type memberType) {
        this.memberType = memberType;
    }

    protected RSList(Type memberType, boolean ignored) {
        this.memberType = memberType;
    }

    @Override
    public Object coerce(Object value) throws CoercionException {
        if (value.getClass().isArray()) {
            List<Object> coerced = value.getClass() == float[].class ? Floats.asList((float[])((float[])value)) : (value.getClass() == double[].class ? Doubles.asList((double[])((double[])value)) : (value.getClass() == byte[].class ? Bytes.asList((byte[])((byte[])value)) : (value.getClass() == short[].class ? Shorts.asList((short[])((short[])value)) : (value.getClass() == char[].class ? Chars.asList((char[])((char[])value)) : (value.getClass() == int[].class ? Ints.asList((int[])((int[])value)) : (value.getClass() == long[].class ? Longs.asList((long[])((long[])value)) : Arrays.asList((Object[])value)))))));
            coerced = Lists.newArrayList((Iterable)coerced);
            coerced.replaceAll(raw -> this.memberType.coerce(raw));
            return coerced;
        }
        if (value instanceof List) {
            List asList = (List)value;
            ArrayList<Object> newList = new ArrayList<Object>(asList.size());
            for (Object object : asList) {
                newList.add(this.memberType.coerce(object));
            }
            return newList;
        }
        throw new CoercionException(value, this);
    }

    @Override
    public Class<?> internalType() {
        return List.class;
    }

    @Override
    public Struct asStruct() {
        return Struct.of("value", this);
    }

    public Type getMemberType() {
        return this.memberType;
    }

    @Override
    public int estimateSize(Object entry) {
        int total = 0;
        List asList = (List)entry;
        for (Object object : asList) {
            total += this.memberType.estimateSize(object);
        }
        return total;
    }

    @Override
    public void toBytes(DataOutputStream os, Object toWrite) throws IOException {
        List listToWrite = (List)toWrite;
        int members = listToWrite.size();
        os.writeInt(members);
        for (Object object : listToWrite) {
            this.memberType.toBytes(os, object);
        }
    }

    @Override
    public Object fromBytes(DataInputStream in) throws IOException {
        Object[] beingRead = new Object[in.readInt()];
        for (int i = 0; i < beingRead.length; ++i) {
            beingRead[i] = this.memberType.fromBytes(in);
        }
        return Arrays.asList(beingRead);
    }

    public String toString() {
        return String.format("List[%s]", this.memberType);
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + Objects.hashCode(this.memberType);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RSList other = (RSList)obj;
        return Objects.equals(this.memberType, other.memberType);
    }

    @Override
    public Type getContainedType() {
        return this.memberType;
    }
}

