/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.ContainingType;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeInformation;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.typeset.IdentifiedType;
import nz.org.riskscape.engine.typexp.AST;
import nz.org.riskscape.engine.typexp.ComplexTypeConstructor;
import nz.org.riskscape.engine.typexp.TypeArgumentException;

public class Nullable
implements Type,
ContainingType {
    public static final ComplexTypeConstructor TYPE_CONSTRUCTOR = (typeBuilder, ct) -> {
        List<AST> args = ct.args();
        if (args.size() != 1) {
            throw new TypeArgumentException(ct, "one argument expected");
        }
        Type subType = typeBuilder.expectType(args.get(0), ast -> new TypeArgumentException(ct, "nullable expects a type argument"));
        return Nullable.of(subType);
    };
    public static final TypeInformation TYPE_INFORMATION = new TypeInformation("nullable", Nullable.class, Object.class, TYPE_CONSTRUCTOR);
    public static final Nullable TEXT = new Nullable(Types.TEXT);
    public static final Nullable BOOLEAN = new Nullable(Types.BOOLEAN);
    public static final Nullable INTEGER = new Nullable(Types.INTEGER);
    public static final Nullable FLOATING = new Nullable(Types.FLOATING);
    public static final Nullable DECIMAL = new Nullable(Types.DECIMAL);
    public static final Nullable ANYTHING = new Nullable(Types.ANYTHING);
    public static final Nullable DATE = new Nullable(Types.DATE);
    public static final Nullable GEOMETRY = new Nullable(Types.GEOMETRY);
    private final Type containedType;

    public static boolean is(Type toCheck) {
        if (toCheck instanceof IdentifiedType) {
            return ((IdentifiedType)toCheck).getUnderlyingType() instanceof Nullable;
        }
        return toCheck instanceof Nullable;
    }

    public static Type ifTrue(boolean flag, Type wrapped) {
        if (flag) {
            return Nullable.of(wrapped);
        }
        return wrapped;
    }

    public static Type of(Type wrapped) {
        if (wrapped.find(Nullable.class).isPresent()) {
            return wrapped;
        }
        if (wrapped == Types.TEXT) {
            return TEXT;
        }
        if (wrapped == Types.BOOLEAN) {
            return BOOLEAN;
        }
        if (wrapped == Types.INTEGER) {
            return INTEGER;
        }
        if (wrapped == Types.FLOATING) {
            return FLOATING;
        }
        if (wrapped == Types.DECIMAL) {
            return DECIMAL;
        }
        if (wrapped == Types.DATE) {
            return DATE;
        }
        return new Nullable(wrapped);
    }

    protected Nullable(Type wrapped) {
        this.containedType = wrapped;
    }

    @Override
    public Object coerce(Object value) throws CoercionException {
        if (value == null) {
            return null;
        }
        if (value instanceof Optional) {
            Optional opt = (Optional)value;
            if (opt.isPresent()) {
                return this.containedType.coerce(opt.get());
            }
            return null;
        }
        return this.containedType.coerce(value);
    }

    @Override
    public Class<?> internalType() {
        return this.containedType.internalType();
    }

    @Override
    public Struct asStruct() {
        if (this.getContainedType() instanceof Struct) {
            Struct contained = (Struct)this.getContainedType();
            Struct mapped = Struct.of();
            for (Struct.StructMember member : contained.getMembers()) {
                mapped = mapped.add(member.getKey(), Nullable.of(member.getType()));
            }
            return mapped;
        }
        return Struct.of("value", this);
    }

    public int hashCode() {
        return this.containedType.hashCode();
    }

    public boolean equals(Object rhs) {
        if (rhs instanceof Nullable) {
            Nullable rhsNullable = (Nullable)rhs;
            return rhsNullable.containedType.equals(this.containedType);
        }
        return false;
    }

    public String toString() {
        return "Nullable[" + this.containedType.toString() + "]";
    }

    @Override
    public int estimateSize(Object entry) {
        return 1 + this.containedType.estimateSize(entry);
    }

    @Override
    public void toBytes(DataOutputStream os, Object toWrite) throws IOException {
        if (toWrite == null) {
            os.writeBoolean(false);
        } else {
            os.writeBoolean(true);
            this.containedType.toBytes(os, toWrite);
        }
    }

    @Override
    public Object fromBytes(DataInputStream in) throws IOException {
        boolean present = in.readBoolean();
        if (present) {
            return this.containedType.fromBytes(in);
        }
        return null;
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    public static boolean any(Type ... types) {
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].isNullable() && !types[i].find(Nullable.class).isPresent()) continue;
            return true;
        }
        return false;
    }

    public static Type strip(Type mightBeNullable) {
        return mightBeNullable.find(Nullable.class).map(n -> n.getContainedType()).orElse(mightBeNullable);
    }

    public static Type unwrap(Type mightBeNullable) {
        return mightBeNullable.find(Nullable.class).map(n -> n.getContainedType()).orElse(mightBeNullable).getUnwrappedType();
    }

    public static Type rewrap(Type mightBeNullable, Function<Type, Type> wrappingFunction) {
        Type stripped = Nullable.strip(mightBeNullable);
        return Nullable.ifTrue(stripped != mightBeNullable, wrappingFunction.apply(stripped));
    }

    @Override
    @Generated
    public Type getContainedType() {
        return this.containedType;
    }
}

