/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.ScopedLambdaType;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeInformation;
import nz.org.riskscape.engine.types.TypeVisitor;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.typexp.AST;
import nz.org.riskscape.engine.typexp.ComplexTypeConstructor;
import nz.org.riskscape.rl.ast.Lambda;

public class LambdaType
implements Type {
    public static final ComplexTypeConstructor TYPE_CONSTRUCTOR = (typeBuilder, type) -> {
        List<AST> args = type.args();
        List<String> checkedArgs = typeBuilder.expectConstantsOfType(type, Types.TEXT, args, 0).stream().map(Object::toString).collect(Collectors.toList());
        return new LambdaType(checkedArgs);
    };
    public static final TypeInformation TYPE_INFORMATION = new TypeInformation("lambda", LambdaType.class, Lambda.class, TYPE_CONSTRUCTOR);
    public static final LambdaType NO_ARGS = new LambdaType(Collections.emptyList());
    private final List<String> args;
    private final Struct asStruct;

    public static LambdaType create(Lambda lambda) {
        return new LambdaType(lambda.getArguments().stream().map(Token::getValue).collect(Collectors.toList()));
    }

    public LambdaType(List<String> argIdentifiers) {
        this.args = argIdentifiers;
        this.asStruct = Struct.of("value", this);
    }

    public LambdaType(String ... argIdentifiers) {
        this(Arrays.asList(argIdentifiers));
    }

    public ScopedLambdaType scoped(Struct scopeType) {
        return new ScopedLambdaType(scopeType, this.args);
    }

    @Override
    public Object coerce(Object value) throws CoercionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<?> internalType() {
        return Lambda.class;
    }

    @Override
    public Struct asStruct() {
        return this.asStruct;
    }

    @Override
    public int estimateSize(Object entry) {
        return -1;
    }

    @Override
    public void toBytes(DataOutputStream os, Object toWrite) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object fromBytes(DataInputStream in) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LambdaType) {
            return ((LambdaType)obj).args.size() == this.args.size();
        }
        return false;
    }

    public String toString() {
        return String.format("\u03bb(%s)", this.args.stream().collect(Collectors.joining(",")));
    }

    public int hashCode() {
        return Objects.hashCode(this.args);
    }

    @Override
    public <T, U> U visit(TypeVisitor<T, U> tv, T data) {
        return tv.atomicType(this, data);
    }

    @Generated
    public List<String> getArgs() {
        return this.args;
    }
}

