/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import java.nio.ByteBuffer;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.Geom;
import nz.org.riskscape.engine.types.SimpleType;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeVisitor;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.types.WrappingType;
import org.locationtech.jts.geom.LineString;

public abstract class GeomType
extends SimpleType
implements WrappingType {
    public static boolean isAllowNull(Type toCheck) {
        return toCheck.findAllowNull(Geom.class).isPresent();
    }

    @Override
    public Type getUnderlyingType() {
        return Types.GEOMETRY;
    }

    @Override
    public Object coerce(Object value) throws CoercionException {
        Object coerced = this.getUnderlyingType().coerce(value);
        if (!this.internalType().isAssignableFrom(coerced.getClass())) {
            throw new CoercionException(value, this);
        }
        return coerced;
    }

    @Override
    public void write(ByteBuffer buffer, Object value) {
        Types.GEOMETRY.write(buffer, value);
    }

    @Override
    public Object read(ByteBuffer buffer) {
        return Types.GEOMETRY.read(buffer);
    }

    @Override
    public <T extends Type> boolean isA(Class<T> type) {
        return type.isAssignableFrom(this.getClass());
    }

    @Override
    public <T, U> U visit(TypeVisitor<T, U> tv, T data) {
        return WrappingType.super.visit(tv, data);
    }

    public static class Polygon
    extends GeomType {
        @Override
        public Class<?> internalType() {
            return org.locationtech.jts.geom.Polygon.class;
        }
    }

    public static class Point
    extends GeomType {
        @Override
        public Class<?> internalType() {
            return org.locationtech.jts.geom.Point.class;
        }
    }

    public static class Line
    extends GeomType {
        @Override
        public Class<?> internalType() {
            return LineString.class;
        }
    }
}

