/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.MultiGeom;
import nz.org.riskscape.engine.types.SimpleType;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.InputStreamInStream;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;

public class Geom
extends SimpleType {
    public static final WKTReader READER = new WKTReader();
    private static final int HOUSEKEEPING_BYTES = 3;
    private static final int NUM_DIMENSIONS = 2;

    public static Type fromJavaType(Class<? extends Geometry> javaType) {
        if (LineString.class.isAssignableFrom(javaType)) {
            return Types.LINE;
        }
        if (MultiLineString.class.isAssignableFrom(javaType)) {
            return MultiGeom.MULTI_LINE;
        }
        if (Point.class.isAssignableFrom(javaType)) {
            return Types.POINT;
        }
        if (MultiPoint.class.isAssignableFrom(javaType)) {
            return MultiGeom.MULTI_POINT;
        }
        if (Polygon.class.isAssignableFrom(javaType)) {
            return Types.POLYGON;
        }
        if (MultiPolygon.class.isAssignableFrom(javaType)) {
            return MultiGeom.MULTI_POLYGON;
        }
        return Types.GEOMETRY;
    }

    @Override
    public Object coerce(Object value) throws CoercionException {
        this.checkForNull(value);
        if (value instanceof String) {
            try {
                value = READER.read((String)value);
            }
            catch (ParseException e) {
                throw new CoercionException(value, (Type)this, "Could not parse well known text", new Object[]{e});
            }
        }
        if (this.internalType().isAssignableFrom(value.getClass())) {
            return value;
        }
        throw new CoercionException(value, (Type)this, "Can not coerce object of type %s", value.getClass());
    }

    @Override
    public Class<?> internalType() {
        return Geometry.class;
    }

    @Override
    public int estimateSize(Object entry) {
        Geometry geom = (Geometry)entry;
        return 3 + geom.getNumPoints() * 2 * 8;
    }

    @Override
    public void toBytes(DataOutputStream os, Object toWrite) throws IOException {
        Geometry geometry = (Geometry)toWrite;
        WKBWriter writer = new WKBWriter();
        byte[] bytes = writer.write(geometry);
        os.writeInt(geometry.getSRID());
        os.writeInt(bytes.length);
        os.write(bytes);
    }

    @Override
    public Object fromBytes(DataInputStream in) throws IOException {
        try {
            int srid = in.readInt();
            in.readInt();
            GeometryFactory gf = new GeometryFactory(new PrecisionModel(), srid);
            WKBReader reader = new WKBReader(gf);
            return reader.read((InStream)new InputStreamInStream((InputStream)in));
        }
        catch (ParseException e) {
            throw new IOException("Failed to parse bytes from underlying byte stream", e);
        }
    }

    @Override
    public String toString(Object value) {
        if (value instanceof Geometry) {
            Geometry geometry = (Geometry)value;
            return String.format("%s[%d pts]", geometry.getClass().getSimpleName(), geometry.getCoordinates().length);
        }
        return super.toString(value);
    }

    @Override
    public Object read(ByteBuffer buffer) {
        throw new RuntimeException("ByteBuffer deserialization not supported for geometry");
    }

    @Override
    public void write(ByteBuffer buffer, Object value) {
        throw new RuntimeException("ByteBuffer serialization not supported for geometry");
    }

    @Override
    protected String getTypeInformationId() {
        return "geometry";
    }
}

