/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import com.google.common.base.Joiner;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.function.UntypedFunction;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeVisitor;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.util.Pair;

public class FunctionType
implements Type {
    public static final FunctionType WILD = new FunctionType(Collections.emptyList(), Types.ANYTHING);
    public static final Object VISITOR_META_RETURNS = "returns";
    private final Struct asStruct = Struct.of("value", this);
    private final List<Type> argumentTypes;
    private final Type returnType;

    public static FunctionType fromFunction(RiskscapeFunction function) {
        return new FunctionType(function.getArgumentTypes(), function.getReturnType());
    }

    public FunctionType(List<Type> argumentTypes, Type returnType) {
        this.argumentTypes = argumentTypes;
        this.returnType = returnType;
    }

    @Override
    public Object coerce(Object value) throws CoercionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<?> internalType() {
        return UntypedFunction.class;
    }

    @Override
    public Struct asStruct() {
        return this.asStruct;
    }

    public String toString() {
        return String.format("Function(\u0192(%s)=%s)", Joiner.on((String)", ").join(this.argumentTypes), this.returnType);
    }

    @Override
    public int estimateSize(Object entry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toBytes(DataOutputStream os, Object toWrite) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object fromBytes(DataInputStream in) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, U> U visit(TypeVisitor<T, U> tv, T data) {
        ArrayList children = new ArrayList(this.argumentTypes.size() + 1);
        for (Type childType : this.argumentTypes) {
            children.add(Pair.of(childType, TypeVisitor.NO_META));
        }
        children.add(Pair.of(this.returnType, VISITOR_META_RETURNS));
        return tv.compoundType(this, children, data);
    }

    @Generated
    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    @Generated
    public Type getReturnType() {
        return this.returnType;
    }
}

