/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.Rangeable;
import nz.org.riskscape.engine.types.SimpleType;
import nz.org.riskscape.engine.types.Type;

public class Floating
extends SimpleType
implements Rangeable {
    @Override
    public Object coerce(Object value) {
        this.checkForNull(value);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return new BigDecimal((String)value).doubleValue();
            }
            catch (NumberFormatException ex) {
                throw new CoercionException(value, (Type)this, ex, "Failed to parse number from '%s'", value);
            }
        }
        throw new CoercionException(value, this);
    }

    @Override
    public Class<?> internalType() {
        return Double.class;
    }

    @Override
    public int estimateSize(Object entry) {
        return 8;
    }

    @Override
    public void toBytes(DataOutputStream os, Object toWrite) throws IOException {
        os.writeDouble(((Number)toWrite).doubleValue());
    }

    @Override
    public Object fromBytes(DataInputStream in) throws IOException {
        return in.readDouble();
    }

    @Override
    public Object read(ByteBuffer buffer) {
        return buffer.getDouble();
    }

    @Override
    public void write(ByteBuffer buffer, Object value) {
        buffer.putDouble((Double)value);
    }
}

