/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.ContainingType;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeVisitor;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.types.WrappingType;

public class EmptyList
implements Type,
ContainingType,
WrappingType {
    public static final EmptyList INSTANCE = new EmptyList();
    public static final Struct AS_STRUCT = Struct.of("value", INSTANCE);
    private final Type underlyingType = RSList.create(Types.NOTHING);

    private EmptyList() {
    }

    @Override
    public Type getContainedType() {
        return Types.ANYTHING;
    }

    @Override
    public Object coerce(Object value) throws CoercionException {
        if (value instanceof List && ((List)value).isEmpty()) {
            return value;
        }
        throw new CoercionException(value, (Type)this, "can not coerce anything other than an empty list to an empty list", new Object[0]);
    }

    @Override
    public Class<?> internalType() {
        return List.class;
    }

    @Override
    public Struct asStruct() {
        return AS_STRUCT;
    }

    @Override
    public int estimateSize(Object entry) {
        return 0;
    }

    @Override
    public void toBytes(DataOutputStream os, Object toWrite) throws IOException {
    }

    @Override
    public Object fromBytes(DataInputStream in) throws IOException {
        return Collections.emptyList();
    }

    public String toString() {
        return "EmptyList()";
    }

    @Override
    public <T, U> U visit(TypeVisitor<T, U> tv, T data) {
        return tv.atomicType(this, data);
    }

    @Override
    @Generated
    public Type getUnderlyingType() {
        return this.underlyingType;
    }
}

