/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.Rangeable;
import nz.org.riskscape.engine.types.SimpleType;
import nz.org.riskscape.engine.types.Type;

public class Decimal
extends SimpleType
implements Rangeable {
    public static final BigDecimal TWO = new BigDecimal(2);
    private static final int MAYBE_NUM_LONGS = 4;

    @Override
    public Object coerce(Object value) {
        this.checkForNull(value);
        if (value instanceof BigDecimal) {
            return value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Number) {
            return new BigDecimal(((Number)value).doubleValue());
        }
        if (value instanceof String) {
            try {
                return new BigDecimal(value.toString());
            }
            catch (NumberFormatException ex) {
                throw new CoercionException(value, (Type)this, "%s is not a number", value.toString());
            }
        }
        throw new CoercionException(value, this);
    }

    @Override
    public Class<?> internalType() {
        return BigDecimal.class;
    }

    @Override
    public int estimateSize(Object entry) {
        return 32;
    }

    @Override
    public void toBytes(DataOutputStream os, Object toWrite) throws IOException {
        BigDecimal value = (BigDecimal)toWrite;
        int scale = value.scale();
        byte[] unscaledValue = value.unscaledValue().toByteArray();
        os.writeInt(scale);
        os.writeInt(unscaledValue.length);
        os.write(unscaledValue);
    }

    @Override
    public Object fromBytes(DataInputStream in) throws IOException {
        int scale = in.readInt();
        int numBytes = in.readInt();
        byte[] integerBytes = new byte[numBytes];
        in.readFully(integerBytes);
        BigInteger integer = new BigInteger(integerBytes);
        return new BigDecimal(integer, scale);
    }

    @Override
    public Object read(ByteBuffer buffer) {
        int scale = buffer.getInt();
        int numBytes = buffer.getInt();
        byte[] integerBytes = new byte[numBytes];
        buffer.get(integerBytes);
        BigInteger integer = new BigInteger(integerBytes);
        return new BigDecimal(integer, scale);
    }

    @Override
    public void write(ByteBuffer buffer, Object toWrite) {
        BigDecimal value = (BigDecimal)toWrite;
        int scale = value.scale();
        byte[] unscaledValue = value.unscaledValue().toByteArray();
        buffer.putInt(scale);
        buffer.putInt(unscaledValue.length);
        buffer.put(unscaledValue);
    }
}

