/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import nz.org.riskscape.engine.coverage.TypedCoverage;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.ContainingType;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeInformation;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.typexp.AST;
import nz.org.riskscape.engine.typexp.ComplexTypeConstructor;
import nz.org.riskscape.engine.typexp.TypeArgumentException;

public class CoverageType
implements Type,
ContainingType {
    public static final ComplexTypeConstructor TYPE_CONSTRUCTOR = (typeBuilder, type) -> {
        List<AST> args = type.args();
        if (args.size() != 1) {
            throw new TypeArgumentException(type, "single argument expected");
        }
        Type subType = typeBuilder.expectType(args.get(0), ast -> new TypeArgumentException(type, "expected a type"));
        return new CoverageType(subType);
    };
    public static final TypeInformation TYPE_INFORMATION = new TypeInformation("coverage", CoverageType.class, TypedCoverage.class, TYPE_CONSTRUCTOR);
    public static final CoverageType WILD = new CoverageType(Types.ANYTHING);
    private Type memberType;

    public CoverageType(Type memberType) {
        this.memberType = memberType;
    }

    @Override
    public Object coerce(Object value) throws CoercionException {
        this.checkForNull(value);
        if (value instanceof TypedCoverage) {
            TypedCoverage cov = (TypedCoverage)value;
            if (cov.getType().equals(this.memberType)) {
                return value;
            }
            throw new CoercionException(value, (Type)this, "Give coverage's member type does not match - %s != %s", cov.getType(), this.memberType);
        }
        throw new CoercionException(value, (Type)this, "Can not coerce object of type %s", value.getClass());
    }

    @Override
    public Class<?> internalType() {
        return TypedCoverage.class;
    }

    @Override
    public Struct asStruct() {
        return Struct.of("value", this);
    }

    @Override
    public int estimateSize(Object entry) {
        return -1;
    }

    @Override
    public void toBytes(DataOutputStream os, Object toWrite) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object fromBytes(DataInputStream in) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CoverageType) {
            return ((CoverageType)obj).memberType.equals(this.memberType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash("coverage", this.memberType);
    }

    public String toString() {
        return String.format("Coverage[%s]", this.memberType);
    }

    @Override
    public Type getContainedType() {
        return this.memberType;
    }

    @Generated
    public Type getMemberType() {
        return this.memberType;
    }
}

