/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.sort;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Constant;
import nz.org.riskscape.rl.ast.Expression;

public class SortBy {
    public static final SortBy NONE = new SortBy(Constant.string(Boolean.toString(true)), Direction.ASC, null);
    private final Expression expr;
    private final Direction direction;
    private final SortBy next;

    public static SortBy concatenate(SortBy ... clauses) {
        return SortBy.concatenate(Arrays.asList(clauses));
    }

    public static SortBy concatenate(List<SortBy> clauses) {
        SortBy combined = null;
        for (SortBy sort : clauses) {
            if (combined == null) {
                combined = sort;
                continue;
            }
            combined = combined.andThen(sort);
        }
        return combined != null ? combined : NONE;
    }

    public SortBy(Expression expr, Direction dir) {
        this(expr, dir, NONE);
    }

    public List<Problem> validate(Struct tupleType, ExpressionRealizer expressionRealizer) {
        if (this == NONE) {
            return Collections.emptyList();
        }
        ArrayList problems = Lists.newArrayList(this.next.validate(tupleType, expressionRealizer));
        ResultOrProblems<RealizedExpression> type = expressionRealizer.realize((Type)tupleType, this.expr);
        if (type.hasProblems(Problem.Severity.ERROR)) {
            problems.addAll(type.getProblems());
        } else {
            Type unwrapped = Nullable.strip(type.get().getResultType());
            if (!Comparable.class.isAssignableFrom(unwrapped.internalType())) {
                problems.add(Problem.error("Expression '%s' yields type '%s' which is not sortable", this.expr.toSource(), unwrapped));
            }
        }
        return problems;
    }

    public SortBy andThen(SortBy asNext) {
        if (this == NONE) {
            return asNext;
        }
        if (this.next == NONE) {
            return new SortBy(this.expr, this.direction, asNext);
        }
        return new SortBy(this.expr, this.direction, this.next.andThen(asNext));
    }

    public String toString() {
        if (this == NONE) {
            return "SortBy(nothing)";
        }
        String nextString = this.next == NONE ? "" : this.next.toString();
        StringBuilder builder = new StringBuilder(String.format("SortBy(%s %s),", new Object[]{this.expr, this.direction}));
        builder.append(nextString);
        return builder.substring(0, builder.length() - 1);
    }

    @Generated
    public SortBy(Expression expr, Direction direction, SortBy next) {
        this.expr = expr;
        this.direction = direction;
        this.next = next;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortBy)) {
            return false;
        }
        SortBy other = (SortBy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expression this$expr = this.getExpr();
        Expression other$expr = other.getExpr();
        if (this$expr == null ? other$expr != null : !this$expr.equals(other$expr)) {
            return false;
        }
        Direction this$direction = this.getDirection();
        Direction other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !((Object)((Object)this$direction)).equals((Object)other$direction)) {
            return false;
        }
        SortBy this$next = this.getNext();
        SortBy other$next = other.getNext();
        return !(this$next == null ? other$next != null : !((Object)this$next).equals(other$next));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SortBy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expression $expr = this.getExpr();
        result = result * 59 + ($expr == null ? 43 : $expr.hashCode());
        Direction $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : ((Object)((Object)$direction)).hashCode());
        SortBy $next = this.getNext();
        result = result * 59 + ($next == null ? 43 : ((Object)$next).hashCode());
        return result;
    }

    @Generated
    public Expression getExpr() {
        return this.expr;
    }

    @Generated
    public Direction getDirection() {
        return this.direction;
    }

    @Generated
    public SortBy getNext() {
        return this.next;
    }

    public static enum Direction {
        ASC,
        DESC;

    }
}

