/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.rl;

import java.util.Collections;
import java.util.List;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.rl.ast.Constant;
import nz.org.riskscape.rl.ast.Expression;

public interface RealizedExpression
extends AutoCloseable {
    public static final RealizedExpression TRUE = new RealizedExpression(){

        @Override
        public Type getResultType() {
            return Types.BOOLEAN;
        }

        @Override
        public Type getInputType() {
            return Types.ANYTHING;
        }

        @Override
        public Expression getExpression() {
            return Constant.TRUE;
        }

        @Override
        public Object evaluate(Object input) {
            return Boolean.TRUE;
        }

        @Override
        public List<RealizedExpression> getDependencies() {
            return Collections.emptyList();
        }

        public String toString() {
            return "Constant(TRUE)";
        }

        @Override
        public void close() {
        }
    };

    public Type getInputType();

    public Type getResultType();

    public Object evaluate(Object var1);

    default public Object evaluateValues(Object ... values) {
        Tuple input = Tuple.ofValues(this.getInputType().asStruct(), values);
        return this.evaluate(input);
    }

    public Expression getExpression();

    public List<RealizedExpression> getDependencies();

    @Override
    default public void close() {
        for (RealizedExpression dependency : this.getDependencies()) {
            dependency.close();
        }
    }
}

