/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.rl;

import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.FunctionMetadata;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.function.UntypedFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;

@FunctionalInterface
public interface RealizableFunction {
    public static RiskscapeFunction contextOnly(ArgumentList args, Type returnType, Function<RealizationContext, UntypedFunction> constructor) {
        return RealizableFunction.asFunction((context, fc, givenTypes) -> ResultOrProblems.of(RiskscapeFunction.create(RiskscapeFunction.BUILT_IN, args.getArgumentTypes(), returnType, (UntypedFunction)constructor.apply(context), new AutoCloseable[0])), args, returnType);
    }

    public static RiskscapeFunction asFunction(final RealizableFunction function, final ArgumentList args, final Type returnType) {
        return new RiskscapeFunction(){

            @Override
            public Type getReturnType() {
                return returnType;
            }

            @Override
            public ArgumentList getArguments() {
                return args;
            }

            @Override
            public List<Type> getArgumentTypes() {
                return args.getArgumentTypes();
            }

            @Override
            public Object call(List<Object> args2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Optional<RealizableFunction> getRealizable() {
                return Optional.of(function);
            }

            public String toString() {
                return "Wrapped(" + function.toString() + ")";
            }
        };
    }

    public static IdentifiedFunction identified(RealizableFunction function, FunctionMetadata metadata) {
        return new MetadataIdentifiedRealizableFunction(function, metadata);
    }

    default public boolean isDoTypeAdaptation() {
        return true;
    }

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext var1, FunctionCall var2, List<Type> var3);

    public static class MetadataIdentifiedRealizableFunction
    implements IdentifiedFunction {
        private final RealizableFunction function;
        private final FunctionMetadata metadata;

        @Override
        public List<Type> getArgumentTypes() {
            return this.metadata.getArguments().getArgumentTypes();
        }

        @Override
        public ArgumentList getArguments() {
            return this.metadata.getArguments();
        }

        @Override
        public Type getReturnType() {
            return this.metadata.getReturnType();
        }

        @Override
        public Object call(List<Object> args) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            return this.metadata.getId();
        }

        @Override
        public String getDescription() {
            return this.metadata.getDescription();
        }

        @Override
        public URI getSourceURI() {
            return this.metadata.getSource();
        }

        @Override
        public IdentifiedFunction.Category getCategory() {
            return this.metadata.getCategory();
        }

        @Override
        public Optional<RealizableFunction> getRealizable() {
            return Optional.of(this.function);
        }

        @Generated
        public MetadataIdentifiedRealizableFunction(RealizableFunction function, FunctionMetadata metadata) {
            this.function = function;
            this.metadata = metadata;
        }

        @Generated
        public RealizableFunction getFunction() {
            return this.function;
        }

        @Generated
        public FunctionMetadata getMetadata() {
            return this.metadata;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetadataIdentifiedRealizableFunction)) {
                return false;
            }
            MetadataIdentifiedRealizableFunction other = (MetadataIdentifiedRealizableFunction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RealizableFunction this$function = this.getFunction();
            RealizableFunction other$function = other.getFunction();
            if (this$function == null ? other$function != null : !this$function.equals(other$function)) {
                return false;
            }
            FunctionMetadata this$metadata = this.getMetadata();
            FunctionMetadata other$metadata = other.getMetadata();
            return !(this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MetadataIdentifiedRealizableFunction;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RealizableFunction $function = this.getFunction();
            result = result * 59 + ($function == null ? 43 : $function.hashCode());
            FunctionMetadata $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RealizableFunction.MetadataIdentifiedRealizableFunction(function=" + String.valueOf(this.getFunction()) + ", metadata=" + String.valueOf(this.getMetadata()) + ")";
        }
    }
}

