/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.rl;

import java.util.Collection;
import java.util.Collections;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.agg.RealizedAggregateExpression;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.ScopedLambdaType;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeInformation;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.rl.ast.PropertyAccess;

public interface ExpressionRealizer {
    public static final ProblemCode NO_SUCH_MEMBER = ExpressionProblems.get().noSuchStructMember("", Collections.emptyList()).getCode();

    public static String getImplicitTypeName(RealizationContext context, Type type) {
        type = Nullable.strip(type).getUnwrappedType();
        TypeInformation metaClass = context.getProject().getTypeSet().getTypeRegistry().findTypeInformation(type).orElse(null);
        if (type instanceof ScopedLambdaType) {
            return "lambda";
        }
        String typeName = metaClass == null ? type.getClass().getSimpleName() : metaClass.getId();
        return type.find(RSList.class).map(listType -> typeName + "_" + ExpressionRealizer.getImplicitTypeName(context, listType.getMemberType())).orElse(typeName);
    }

    public static String getImplicitName(RealizationContext context, RealizedExpression realized, Collection<String> used) {
        Object converted;
        Expression expr = realized.getExpression();
        Type type = realized.getResultType();
        if (expr instanceof PropertyAccess) {
            converted = ((PropertyAccess)expr).getLastIdentifier().getValue();
        } else if (expr instanceof FunctionCall) {
            FunctionCall fc = (FunctionCall)expr;
            String prefix = fc.getIdentifier().getValue();
            converted = fc.getArguments().size() == 1 && realized.getDependencies().size() == 1 ? prefix + "_" + ExpressionRealizer.getImplicitName(context, realized.getDependencies().get(0), Collections.emptyList()) : prefix;
        } else {
            converted = ExpressionRealizer.getImplicitTypeName(context, type);
        }
        return ExpressionRealizer.makeUnique((String)converted, used);
    }

    public static String makeUnique(String identifier, Collection<String> used) {
        int counter = 2;
        Object suffixed = identifier;
        while (used.contains(suffixed)) {
            suffixed = identifier + "_" + counter++;
        }
        return suffixed;
    }

    default public ResultOrProblems<RealizedExpression> realizeConstant(Expression expression) {
        ResultOrProblems<RealizedExpression> realizedOr = this.realize((Type)Struct.EMPTY_STRUCT, expression);
        if (realizedOr.hasErrors() && realizedOr.getProblems().stream().allMatch(prob -> prob.getCode().equals(NO_SUCH_MEMBER))) {
            return ResultOrProblems.failed(ExpressionProblems.get().constantRequired(expression));
        }
        return realizedOr;
    }

    public ResultOrProblems<RealizedExpression> realize(Type var1, Expression var2);

    public ResultOrProblems<RealizedExpression> realize(Type var1, String var2);

    public ResultOrProblems<RealizedAggregateExpression> realizeAggregate(Type var1, Expression var2);

    public Expression parse(String var1);

    public RealizedExpression asStruct(RealizationContext var1, RealizedExpression var2);

    public static enum ProblemCodes implements ProblemCode
    {
        KEYWORD_DOES_NOT_EXIST,
        KEYWORD_REQUIRED,
        KEYWORD_OUT_OF_ORDER,
        MISSING_KEYWORD_ARGUMENTS;

    }
}

