/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.resource.ResourceProblems;
import nz.org.riskscape.problem.ResultOrProblems;

public interface Resource {
    public static final Options SECURE_OPTIONS = new Options();
    public static final URI UNKNOWN_URI = URI.create("null:null");
    public static final InputStream NO_BYTES = new InputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }
    };
    public static final Resource UNKNOWN = new PseudoResource(UNKNOWN_URI);

    public URI getLocation();

    public InputStream getContentStream() throws RiskscapeIOException;

    default public Reader getContentReader() throws RiskscapeIOException {
        return new InputStreamReader(this.getContentStream());
    }

    default public String getContentAsString() throws RiskscapeIOException {
        Reader reader = this.getContentReader();
        char[] strBuf = new char[1024];
        StringBuffer buffer = new StringBuffer();
        int read = 0;
        try {
            while ((read = reader.read(strBuf)) != -1) {
                buffer.append(strBuf, 0, read);
            }
        }
        catch (IOException e) {
            throw new RiskscapeIOException("Failed to read string from reader", e);
        }
        return buffer.toString();
    }

    default public ResultOrProblems<Path> ensureLocal(Options secureOptions, String fileExtension) {
        return ResultOrProblems.failed(ResourceProblems.get().ensureLocalNotSupported(this.getLocation()));
    }

    default public ResultOrProblems<Path> ensureLocal(Options options) {
        return this.ensureLocal(options, null);
    }

    default public Optional<Path> getLocal() {
        return Optional.empty();
    }

    default public Optional<String> getMediaType() {
        return Optional.empty();
    }

    public static class Options {
        public boolean allowInsecure = "true".equals(System.getenv("RS_ALLOW_INSECURE"));
        public Optional<Path> tempDirectory = Optional.empty();

        @Generated
        public Options() {
        }

        @Generated
        public boolean isAllowInsecure() {
            return this.allowInsecure;
        }

        @Generated
        public Optional<Path> getTempDirectory() {
            return this.tempDirectory;
        }

        @Generated
        public void setAllowInsecure(boolean allowInsecure) {
            this.allowInsecure = allowInsecure;
        }

        @Generated
        public void setTempDirectory(Optional<Path> tempDirectory) {
            this.tempDirectory = tempDirectory;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Options)) {
                return false;
            }
            Options other = (Options)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAllowInsecure() != other.isAllowInsecure()) {
                return false;
            }
            Optional<Path> this$tempDirectory = this.getTempDirectory();
            Optional<Path> other$tempDirectory = other.getTempDirectory();
            return !(this$tempDirectory == null ? other$tempDirectory != null : !((Object)this$tempDirectory).equals(other$tempDirectory));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Options;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAllowInsecure() ? 79 : 97);
            Optional<Path> $tempDirectory = this.getTempDirectory();
            result = result * 59 + ($tempDirectory == null ? 43 : ((Object)$tempDirectory).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Resource.Options(allowInsecure=" + this.isAllowInsecure() + ", tempDirectory=" + String.valueOf(this.getTempDirectory()) + ")";
        }
    }

    public static class PseudoResource
    implements Resource {
        private final URI location;

        @Override
        public InputStream getContentStream() throws RiskscapeIOException {
            return NO_BYTES;
        }

        @Generated
        public PseudoResource(URI location) {
            this.location = location;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PseudoResource)) {
                return false;
            }
            PseudoResource other = (PseudoResource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            URI this$location = this.getLocation();
            URI other$location = other.getLocation();
            return !(this$location == null ? other$location != null : !((Object)this$location).equals(other$location));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PseudoResource;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            URI $location = this.getLocation();
            result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
            return result;
        }

        @Override
        @Generated
        public URI getLocation() {
            return this.location;
        }
    }
}

