/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public abstract class BaseResource
implements Resource {
    protected final URI location;

    @Override
    public ResultOrProblems<Path> ensureLocal(Resource.Options options, String extension) {
        try {
            Path tempDir = options.tempDirectory.isPresent() ? Files.createTempDirectory(options.tempDirectory.get(), this.getClass().getSimpleName(), new FileAttribute[0]) : Files.createTempDirectory(this.getClass().getSimpleName(), new FileAttribute[0]);
            String filename = this.ensureExtension(this.localFilename(this.location), extension);
            Path tempResource = tempDir.resolve(filename);
            try (InputStream is = this.getContentStream();){
                Files.copy(is, tempResource, new CopyOption[0]);
            }
            return ResultOrProblems.of(tempResource);
        }
        catch (IOException e) {
            throw new RiskscapeIOException(Problems.caught(e));
        }
    }

    private String ensureExtension(String localFilename, String extension) {
        if (extension == null) {
            return localFilename;
        }
        Object suffix = extension.equals("") ? "" : (extension.startsWith(".") ? extension : "." + extension);
        int dotIndex = localFilename.indexOf(46);
        if (dotIndex == -1) {
            return localFilename + (String)suffix;
        }
        return localFilename.substring(0, dotIndex) + (String)suffix;
    }

    protected String localFilename(URI uri) {
        String path = uri.getPath();
        if (path != null && !path.endsWith("/")) {
            int lastSlash = path.lastIndexOf("/");
            if (lastSlash > -1) {
                return path.substring(lastSlash + 1);
            }
            return path;
        }
        return "resource";
    }

    @Generated
    public BaseResource(URI location) {
        this.location = location;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseResource)) {
            return false;
        }
        BaseResource other = (BaseResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URI this$location = this.getLocation();
        URI other$location = other.getLocation();
        return !(this$location == null ? other$location != null : !((Object)this$location).equals(other$location));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseResource;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        return result;
    }

    @Override
    @Generated
    public URI getLocation() {
        return this.location;
    }
}

