/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.relation;

import com.google.common.collect.Streams;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;
import lombok.NonNull;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.relation.Singleton;

public interface TupleIterator
extends Iterator<Tuple>,
AutoCloseable {
    public static final TupleIterator EMPTY = new TupleIterator(){

        @Override
        public Tuple next() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public String toString() {
            return "Empty()";
        }
    };

    public static TupleIterator wrapped(final @NonNull Iterator<Tuple> iterator, final @NonNull Optional<Runnable> onClose) {
        if (iterator == null) {
            throw new NullPointerException("iterator is marked non-null but is null");
        }
        if (onClose == null) {
            throw new NullPointerException("onClose is marked non-null but is null");
        }
        return new TupleIterator(){

            @Override
            public void close() {
                onClose.ifPresent(Runnable::run);
            }

            @Override
            public Tuple next() {
                Tuple value = (Tuple)iterator.next();
                return value;
            }

            @Override
            public void remove() {
                iterator.remove();
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            public String toString() {
                return String.format("Wrapped(source=%s)", iterator);
            }
        };
    }

    public static <T> TupleIterator wrappedAndMapped(final @NonNull Iterator<T> iterator, final @NonNull Function<T, Tuple> mapper) {
        if (iterator == null) {
            throw new NullPointerException("iterator is marked non-null but is null");
        }
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        return new TupleIterator(){

            @Override
            public Tuple next() {
                return (Tuple)mapper.apply(iterator.next());
            }

            @Override
            public void remove() {
                iterator.remove();
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            public String toString() {
                return String.format("WrappedAndMapped(source=%s mapper=%s)", iterator, mapper);
            }
        };
    }

    @Override
    default public void close() {
    }

    default public <A, R> R collect(Collector<? super Tuple, A, R> collector) {
        return Streams.stream((Iterator)this).collect(collector);
    }

    @Override
    default public void forEachRemaining(Consumer<? super Tuple> action) {
        try {
            Iterator.super.forEachRemaining(action);
        }
        finally {
            this.close();
        }
    }

    public static TupleIterator singleton(Tuple tuple) {
        return new Singleton(tuple);
    }
}

