/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.relation;

import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.data.SelfDescribingScalarData;
import nz.org.riskscape.engine.pipeline.Realized;
import nz.org.riskscape.engine.pipeline.TupleInput;
import nz.org.riskscape.engine.projection.Projection;
import nz.org.riskscape.engine.relation.SpatialMetadata;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.restriction.Restriction;
import nz.org.riskscape.engine.types.Geom;
import nz.org.riskscape.engine.types.Referenced;
import nz.org.riskscape.engine.types.RelationType;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.ResultOrProblems;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public interface Relation
extends Realized,
SelfDescribingScalarData {
    @Deprecated
    default public Struct getType() {
        return this.getProducedType();
    }

    @Override
    public Struct getProducedType();

    public TupleIterator iterator();

    public ResultOrProblems<Relation> project(Projection var1);

    public ResultOrProblems<Relation> restrict(Restriction var1);

    default public Stream<Tuple> stream() {
        TupleIterator iterator = this.iterator();
        Spliterator<Tuple> spliterator = Spliterators.spliteratorUnknownSize(iterator, 1280);
        return StreamSupport.stream(spliterator, false);
    }

    default public Optional<SpatialMetadata> getSpatialMetadata() {
        return Optional.empty();
    }

    public Relation skipInvalid(ProblemSink var1);

    public boolean hasSkipOnInvalid();

    public String getSourceInformation();

    default public Optional<ReferencedEnvelope> calculateBounds() {
        return this.getSpatialMetadata().flatMap(sm -> {
            try (TupleIterator iterator = this.skipInvalid(ProblemSink.DEVNULL).iterator();){
                if (!iterator.hasNext()) {
                    Optional optional = Optional.empty();
                    return optional;
                }
                Tuple tuple = (Tuple)iterator.next();
                Struct.StructMember geomMember = sm.getGeometryStructMember();
                Geometry geometry = (Geometry)tuple.fetch(geomMember);
                Envelope envelope = geometry.getEnvelopeInternal();
                while (iterator.hasNext()) {
                    tuple = (Tuple)iterator.next();
                    geometry = (Geometry)tuple.fetch(geomMember);
                    envelope.expandToInclude(geometry.getEnvelopeInternal());
                }
                Optional<ReferencedEnvelope> optional = Optional.of(new ReferencedEnvelope(envelope.getMinX(), envelope.getMaxX(), envelope.getMinY(), envelope.getMaxY(), sm.getCrs()));
                return optional;
            }
        });
    }

    public long getLimit();

    public long getOffset();

    default public Relation limit(long newLimit) {
        return this.limitAndOffset(newLimit, this.getOffset());
    }

    default public Relation offset(long newOffset) {
        return this.limitAndOffset(this.getLimit(), newOffset);
    }

    public Relation limitAndOffset(long var1, long var3);

    @Override
    default public Type getScalarDataType() {
        RelationType type = new RelationType(this.getType());
        List geomMembers = this.getType().getMembers().stream().filter(m -> m.getType().findAllowNull(Geom.class).isPresent()).collect(Collectors.toList());
        if (geomMembers.size() == 1) {
            Type geomMember = ((Struct.StructMember)geomMembers.get(0)).getType();
            return geomMember.findAllowNull(Referenced.class).map(r -> r.wrapNullable(type)).orElse(type);
        }
        return type;
    }

    default public Optional<Long> size() {
        return Optional.empty();
    }

    default public TupleInput toTupleInput() {
        return TupleInput.fromIterator(this.getType(), this.iterator(), this.size());
    }
}

