/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.query;

import java.util.function.Supplier;
import lombok.NonNull;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.types.Geom;
import nz.org.riskscape.engine.types.GeomType;
import nz.org.riskscape.engine.types.Struct;

public class TupleUtils {
    private static final int DEBUG_VALUE_MAX_LENGTH = 8;

    public static Struct.StructMember findGeometryMember(@NonNull Struct source, FindOption option) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return TupleUtils.findGeometryMember(source, option, () -> new RiskscapeException(String.format("Failed to find geometry on %s according to option %s", new Object[]{source, option})));
    }

    public static Struct.StructMember findGeometryMember(@NonNull Struct source, @NonNull FindOption option, @NonNull Supplier<RuntimeException> failedHandler) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (option == null) {
            throw new NullPointerException("option is marked non-null but is null");
        }
        if (failedHandler == null) {
            throw new NullPointerException("failedHandler is marked non-null but is null");
        }
        Struct.StructMember found = null;
        for (Struct.StructMember member : source.getMembers()) {
            if (!GeomType.isAllowNull(member.getType())) continue;
            if (found == null) {
                found = member;
                continue;
            }
            if (option == FindOption.ONE_REQUIRED) {
                throw failedHandler.get();
            }
            return found;
        }
        if (found == null && option != FindOption.OPTIONAL) {
            throw failedHandler.get();
        }
        return found;
    }

    public static Struct.StructMember findRequiredGeometryMember(Struct struct) {
        return TupleUtils.findGeometryMember(struct, FindOption.ONE_REQUIRED, () -> new RiskscapeException("No single geometry member found on " + String.valueOf(struct)));
    }

    public static boolean hasGeometryMember(Struct struct) {
        return TupleUtils.findGeometryMember(struct, FindOption.OPTIONAL, () -> new RiskscapeException("Internal error")) != null;
    }

    public static String getContentSummary(Tuple tuple) {
        StringBuilder bldr = new StringBuilder("{");
        for (Struct.StructMember member : tuple.getStruct().getMembers()) {
            Object value;
            if (member.getType().findAllowNull(Geom.class).isPresent()) continue;
            if (bldr.length() != 1) {
                bldr.append(", ");
            }
            if (((String)(value = member.getType().toString(tuple.fetch(member)))).length() > 8) {
                value = ((String)value).substring(0, 7) + "\u2026";
            }
            bldr.append(member.getKey()).append("=").append((String)value);
        }
        return bldr.append("}").toString();
    }

    public static enum FindOption {
        ONE_REQUIRED,
        ANY_REQUIRED,
        OPTIONAL;

    }
}

