/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.problem;

import com.google.common.base.CaseFormat;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.problem.Affecting;
import nz.org.riskscape.engine.problem.ProblemPlaceholder;
import nz.org.riskscape.engine.problem.SeverityLevel;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.Problems;

public class ProblemFactoryProxy
implements InvocationHandler {
    private static final Object[] NO_ARGS = new Object[0];

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        List<Object> children;
        boolean lastArgsIsChildren;
        if (args == null) {
            args = NO_ARGS;
        }
        if (lastArgsIsChildren = this.isLastArgChildren(method)) {
            children = this.getChildrenFromArgs(args);
            Object[] newArgs = new Object[args.length - 1];
            System.arraycopy(args, 0, newArgs, 0, args.length - 1);
            args = newArgs;
        } else {
            children = List.of();
        }
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Object affecting = this.getAffecting(parameterAnnotations, args);
        Problem.Severity severity = Problem.Severity.ERROR;
        SeverityLevel annotatedSeverity = method.getAnnotation(SeverityLevel.class);
        if (annotatedSeverity != null) {
            severity = annotatedSeverity.value();
        }
        if (children.size() > 0) {
            severity = Problem.max(children);
        }
        JavaMethodCode problemCode = new JavaMethodCode(method);
        return new Problem(severity, "", args, null, problemCode, Problem.wrapAffectedObject(affecting), Problems.from(children));
    }

    private boolean isLastArgChildren(Method method) {
        Class<?>[] types = method.getParameterTypes();
        if (types.length == 0) {
            return false;
        }
        return types[types.length - 1] == Problem[].class;
    }

    private List<Problem> getChildrenFromArgs(Object[] args) {
        Problem[] children = (Problem[])args[args.length - 1];
        if (children != null) {
            return List.of(children);
        }
        return List.of();
    }

    private Object getAffecting(Annotation[][] parameterAnnotations, Object[] args) {
        String name = null;
        Class clazz = null;
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = parameterAnnotations[i]) {
                if (!annotation.annotationType().equals(Affecting.class)) continue;
                Affecting affecting = (Affecting)annotation;
                if (affecting.value() == Affecting.Target.OBJECT) {
                    return args[i];
                }
                if (affecting.value() == Affecting.Target.NAME) {
                    name = args[i].toString();
                    continue;
                }
                clazz = (Class)args[i];
            }
        }
        if (name != null) {
            return new ProblemPlaceholder(name, clazz);
        }
        if (args.length == 0) {
            return null;
        }
        return args[0];
    }

    public static class JavaMethodCode
    implements ProblemCode {
        private final Method method;

        @Override
        public String toKey() {
            return this.method.getDeclaringClass().getCanonicalName() + "." + this.name();
        }

        @Override
        public String name() {
            return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, this.method.getName());
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProblemCode) {
                ProblemCode rhs = (ProblemCode)obj;
                return rhs.toKey().equals(this.toKey());
            }
            return false;
        }

        public int hashCode() {
            return this.toKey().hashCode();
        }

        public String toString() {
            return String.format("JavaMethodCode(%s)", this.toKey());
        }

        @Generated
        public JavaMethodCode(Method method) {
            this.method = method;
        }
    }
}

