/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.plugin;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.plugin.PluginDescriptor;
import nz.org.riskscape.engine.plugin.PluginFeature;
import nz.org.riskscape.engine.plugin.PluginRuntimeException;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemSink;

public abstract class Plugin {
    private final PluginDescriptor descriptor;

    public String getId() {
        return this.descriptor.getPluginId();
    }

    public Plugin(PluginDescriptor pDescriptor) {
        Objects.requireNonNull(pDescriptor, "pDescriptor must not be null");
        this.descriptor = pDescriptor;
    }

    protected void startUp(Map<String, List<String>> settings) throws PluginRuntimeException {
    }

    public void startUp(Map<String, List<String>> settings, ProblemSink terminal) {
        this.startUp(settings);
    }

    public void shutDown() throws PluginRuntimeException {
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.shutDown();
    }

    public abstract List<Problem> initializeEngine(Engine var1);

    public void initializeEngine(Engine engine, ProblemSink problemSink) {
        List<Problem> problems = this.initializeEngine(engine);
        problems.forEach(p -> problemSink.log((Problem)p));
    }

    public List<Problem> initializeProject(Project project, Engine engine) {
        return Collections.emptyList();
    }

    @Deprecated
    public <T> Optional<T> supportsFeature(Class<T> spi) {
        if (spi.isAssignableFrom(this.getClass())) {
            return Optional.ofNullable(spi.cast(this));
        }
        return Optional.empty();
    }

    public ClassLoader getI18nClassLoader() {
        return this.descriptor.getI18nClassLoader();
    }

    public List<Class<? extends PluginFeature>> getExtensionPoints() {
        return Collections.emptyList();
    }

    public List<PluginFeature> getFeatures() {
        return Collections.emptyList();
    }

    @Generated
    public PluginDescriptor getDescriptor() {
        return this.descriptor;
    }
}

