/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.plugin.PluginFeature;

public class ExtensionPoint<T extends PluginFeature>
implements Identified {
    private final Class<T> featureClass;
    private final List<T> collected = new ArrayList<T>();

    @Override
    public String getId() {
        return this.featureClass.getCanonicalName();
    }

    public void addFeature(T feature) {
        this.collected.add(feature);
    }

    public boolean addFeatureIf(PluginFeature feature) {
        if (this.featureClass.isInstance(feature)) {
            this.addFeature((PluginFeature)this.featureClass.cast(feature));
            return true;
        }
        return false;
    }

    public List<T> getFeatures() {
        return Collections.unmodifiableList(this.collected);
    }

    public <U extends PluginFeature> Optional<ExtensionPoint<U>> checkFeatureClass(Class<U> ofClass) {
        if (ofClass.equals(this.featureClass)) {
            ExtensionPoint thus = this;
            return Optional.of(thus);
        }
        return Optional.empty();
    }

    public String toString() {
        return String.format("ExtensionPoint(%s [%s])", this.featureClass.getSimpleName(), this.collected);
    }

    @Generated
    public ExtensionPoint(Class<T> featureClass) {
        this.featureClass = featureClass;
    }

    @Generated
    public Class<T> getFeatureClass() {
        return this.featureClass;
    }
}

