/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.plugin;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import lombok.Generated;
import nz.org.riskscape.ReflectionUtils;
import nz.org.riskscape.engine.plugin.PluginFeature;

public abstract class ConstructorFeature<A, T>
implements PluginFeature {
    private final Class<T> implementationClass;

    public T newInstance(A arg) {
        ParameterizedType superType = (ParameterizedType)this.getClass().getGenericSuperclass();
        Class argClass = (Class)superType.getActualTypeArguments()[0];
        try {
            try {
                Constructor<T> constructor = this.implementationClass.getConstructor(argClass);
                return constructor.newInstance(arg);
            }
            catch (NoSuchMethodException e) {
                Constructor<T> constructor = this.implementationClass.getConstructor(new Class[0]);
                return constructor.newInstance(new Object[0]);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to create feature " + String.valueOf(this.implementationClass), e);
        }
    }

    public T newInstance() {
        return ReflectionUtils.newInstance(this.implementationClass);
    }

    public String toString() {
        return String.format("%s(%s)", this.getClass().getSimpleName(), this.implementationClass.getSimpleName());
    }

    @Generated
    public ConstructorFeature(Class<T> implementationClass) {
        this.implementationClass = implementationClass;
    }
}

