/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.pipeline;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.bind.ParameterSet;
import nz.org.riskscape.engine.i18n.RiskscapeMessage;
import nz.org.riskscape.engine.pipeline.Collector;
import nz.org.riskscape.engine.pipeline.RealizationInput;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.engine.projection.FlatProjector;
import nz.org.riskscape.engine.projection.Projector;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.restriction.Restrictor;

public interface Step
extends Identified {
    public static final Set<Class<?>> FUNCTOR_INTERFACES = Sets.newHashSet((Object[])new Class[]{Relation.class, Restrictor.class, Projector.class, FlatProjector.class, Collector.class});

    public RiskscapeMessage getDescription();

    @Deprecated
    default public List<Parameter> getDeclaredParameters() {
        return ImmutableList.copyOf(this.getParameterSet().getDeclared());
    }

    public ParameterSet getParameterSet();

    public RealizedPipeline realize(RealizationInput var1);

    public Range<Integer> getInputArity();

    default public Optional<Parameter> getDeclaredParameter(String name) {
        return this.getDeclaredParameters().stream().filter(p -> p.getName().equals(name)).findFirst();
    }

    default public List<String> getInputNames() {
        return Collections.emptyList();
    }

    default public Optional<String> getDefaultInputName() {
        if (!this.getInputNames().isEmpty()) {
            return Optional.of(this.getInputNames().get(0));
        }
        return Optional.empty();
    }

    default public boolean hasNamedInput(String namedInput) {
        return this.getInputNames().contains(namedInput);
    }

    default public List<String> getDeclaredParameterNames() {
        return this.getParameterSet().getDeclared().stream().map(Parameter::getName).collect(Collectors.toList());
    }
}

