/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.pipeline;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.engine.pipeline.NullStep;
import nz.org.riskscape.engine.pipeline.PipelineProblems;
import nz.org.riskscape.engine.pipeline.RealizationInput;
import nz.org.riskscape.engine.pipeline.Realized;
import nz.org.riskscape.engine.pipeline.Step;
import nz.org.riskscape.engine.relation.EmptyRelation;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.pipeline.ast.StepDefinition;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public class RealizedStep
implements AutoCloseable {
    private final String name;
    @NonNull
    private final Step implementation;
    private final StepDefinition ast;
    @NonNull
    private final ResultOrProblems<? extends Realized> result;
    @NonNull
    private final Map<String, List<?>> boundParameters;
    @NonNull
    private final List<RealizedStep> dependencies;
    @NonNull
    private final Struct produces;

    public static RealizedStep emptyInput(String name, Struct type) {
        return new RealizedStep(name, NullStep.INSTANCE, new StepDefinition(name), ResultOrProblems.of(new EmptyRelation(type)), Collections.emptyMap(), Collections.emptyList(), type);
    }

    public static RealizedStep named(String named) {
        return new RealizedStep(named, NullStep.INSTANCE, new StepDefinition(named), ResultOrProblems.of(new EmptyRelation(Struct.EMPTY_STRUCT)), Collections.emptyMap(), Collections.emptyList(), Struct.EMPTY_STRUCT);
    }

    public static RealizedStep fromInput(RealizationInput input) {
        return new RealizedStep(input.getName(), NullStep.INSTANCE, input.getStepDefinition(), ResultOrProblems.of(new EmptyRelation(Struct.EMPTY_STRUCT)), input.getParameters(), input.getDependencies(), Struct.EMPTY_STRUCT);
    }

    public boolean isFailed() {
        return this.result.hasErrors() || Iterables.any(this.dependencies, RealizedStep::isFailed);
    }

    public boolean isDirectlyFailed() {
        return this.result.hasErrors() && !Iterables.any(this.dependencies, RealizedStep::isFailed);
    }

    public boolean hasDependencies() {
        return !this.dependencies.isEmpty();
    }

    public boolean hasNoDependencies() {
        return this.dependencies.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public String getStepName() {
        return this.name;
    }

    public String toString() {
        return this.name + ":" + String.valueOf(this.getProduces());
    }

    public Optional<Problem> getFailureProblem() {
        if (this.result.hasErrors()) {
            Problem parentProblem = Problems.get(PipelineProblems.class).cannotRealize(this.ast);
            return Optional.of(parentProblem.withChildren(this.result.getProblems()));
        }
        return Optional.empty();
    }

    @Override
    public void close() {
        this.result.ifPresent(Realized::close);
    }

    public Class<? extends Realized> getStepType() {
        return Realized.getRealizedInterface(this.getResult().get().getClass());
    }

    public <T extends Realized> Optional<T> getRealized(Class<T> stepType) {
        return this.getResult().map(realized -> stepType.isInstance(realized) ? Optional.of((Realized)stepType.cast(realized)) : Optional.empty()).orElse(Optional.empty());
    }

    public List<Problem> getProblems() {
        if (this.result.hasProblems()) {
            return this.result.getProblems();
        }
        return Collections.emptyList();
    }

    public RealizedStep withProblems(Problem ... problems) {
        return this.withProblems(Arrays.asList(problems));
    }

    public RealizedStep withProblems(List<Problem> problems) {
        if (Problem.hasErrors(problems)) {
            return new RealizedStep(this.name, this.implementation, this.ast, ResultOrProblems.failed(problems), this.boundParameters, this.dependencies, Struct.EMPTY_STRUCT);
        }
        return new RealizedStep(this.name, this.implementation, this.ast, this.result.withMoreProblems(problems), this.boundParameters, this.dependencies, this.produces);
    }

    public RealizedStep realizedBy(Step step) {
        return new RealizedStep(this.name, step, this.ast, this.result, this.boundParameters, this.dependencies, this.produces);
    }

    public RealizedStep withResult(ResultOrProblems<? extends Realized> realizedOr) {
        return new RealizedStep(this.name, this.implementation, this.ast, realizedOr, this.boundParameters, this.dependencies, realizedOr.map(Realized::getProducedType).orElse(Struct.EMPTY_STRUCT));
    }

    public RealizedStep withResult(Realized realized) {
        return this.withResult(realized, realized.getProducedType());
    }

    public RealizedStep withResult(Realized realized, Struct newType) {
        return new RealizedStep(this.name, this.implementation, this.ast, ResultOrProblems.of(realized), this.boundParameters, this.dependencies, newType);
    }

    public RealizedStep withName(String newName) {
        return new RealizedStep(newName, this.implementation, this.ast, this.result, this.boundParameters, this.dependencies, this.produces);
    }

    public RealizedStep withDependencies(RealizedStep ... newDependencies) {
        return this.withDependencies(List.of(newDependencies));
    }

    public RealizedStep withDependencies(List<RealizedStep> newDependencies) {
        return new RealizedStep(this.name, this.implementation, this.ast, this.result, this.boundParameters, newDependencies, this.produces);
    }

    public RealizedStep withParameters(Map<String, List<?>> newParams) {
        return new RealizedStep(this.name, this.implementation, this.ast, this.result, newParams, this.dependencies, this.produces);
    }

    public RealizedStep withAst(StepDefinition defn) {
        return new RealizedStep(this.name, this.implementation, defn, this.result, this.boundParameters, this.dependencies, this.produces);
    }

    @Generated
    public RealizedStep(String name, @NonNull Step implementation, StepDefinition ast, @NonNull ResultOrProblems<? extends Realized> result, @NonNull Map<String, List<?>> boundParameters, @NonNull List<RealizedStep> dependencies, @NonNull Struct produces) {
        if (implementation == null) {
            throw new NullPointerException("implementation is marked non-null but is null");
        }
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        if (boundParameters == null) {
            throw new NullPointerException("boundParameters is marked non-null but is null");
        }
        if (dependencies == null) {
            throw new NullPointerException("dependencies is marked non-null but is null");
        }
        if (produces == null) {
            throw new NullPointerException("produces is marked non-null but is null");
        }
        this.name = name;
        this.implementation = implementation;
        this.ast = ast;
        this.result = result;
        this.boundParameters = boundParameters;
        this.dependencies = dependencies;
        this.produces = produces;
    }

    @NonNull
    @Generated
    public Step getImplementation() {
        return this.implementation;
    }

    @Generated
    public StepDefinition getAst() {
        return this.ast;
    }

    @NonNull
    @Generated
    public ResultOrProblems<? extends Realized> getResult() {
        return this.result;
    }

    @NonNull
    @Generated
    public Map<String, List<?>> getBoundParameters() {
        return this.boundParameters;
    }

    @NonNull
    @Generated
    public List<RealizedStep> getDependencies() {
        return this.dependencies;
    }

    @NonNull
    @Generated
    public Struct getProduces() {
        return this.produces;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RealizedStep)) {
            return false;
        }
        RealizedStep other = (RealizedStep)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Step this$implementation = this.getImplementation();
        Step other$implementation = other.getImplementation();
        if (this$implementation == null ? other$implementation != null : !this$implementation.equals(other$implementation)) {
            return false;
        }
        StepDefinition this$ast = this.getAst();
        StepDefinition other$ast = other.getAst();
        if (this$ast == null ? other$ast != null : !((Object)this$ast).equals(other$ast)) {
            return false;
        }
        Map<String, List<?>> this$boundParameters = this.getBoundParameters();
        Map<String, List<?>> other$boundParameters = other.getBoundParameters();
        if (this$boundParameters == null ? other$boundParameters != null : !((Object)this$boundParameters).equals(other$boundParameters)) {
            return false;
        }
        List<RealizedStep> this$dependencies = this.getDependencies();
        List<RealizedStep> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        Struct this$produces = this.getProduces();
        Struct other$produces = other.getProduces();
        return !(this$produces == null ? other$produces != null : !((Object)this$produces).equals(other$produces));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RealizedStep;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Step $implementation = this.getImplementation();
        result = result * 59 + ($implementation == null ? 43 : $implementation.hashCode());
        StepDefinition $ast = this.getAst();
        result = result * 59 + ($ast == null ? 43 : ((Object)$ast).hashCode());
        Map<String, List<?>> $boundParameters = this.getBoundParameters();
        result = result * 59 + ($boundParameters == null ? 43 : ((Object)$boundParameters).hashCode());
        List<RealizedStep> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        Struct $produces = this.getProduces();
        result = result * 59 + ($produces == null ? 43 : ((Object)$produces).hashCode());
        return result;
    }
}

