/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.pipeline;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.pipeline.AutoClosingException;
import nz.org.riskscape.engine.pipeline.ExecutionContext;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.pipeline.PipelineMetadata;
import nz.org.riskscape.pipeline.ast.PipelineDeclaration;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;

public class RealizedPipeline
implements AutoCloseable {
    private final ExecutionContext context;
    private final PipelineDeclaration ast;
    private final List<RealizedStep> realizedSteps;
    private final List<Problem> problems;
    private final PipelineMetadata metadata;

    public static RealizedPipeline empty(ExecutionContext context, PipelineDeclaration pipeline) {
        return new RealizedPipeline(context, pipeline, List.of());
    }

    public RealizedPipeline(ExecutionContext context, PipelineDeclaration pipeline, List<RealizedStep> steps) {
        this(context, pipeline, steps, Collections.emptyList(), pipeline.getMetadata());
    }

    public RealizedPipeline(ExecutionContext context, PipelineDeclaration pipeline, List<RealizedStep> steps, List<Problem> problems) {
        this(context, pipeline, steps, problems, pipeline.getMetadata());
    }

    @Override
    public void close() {
        ArrayList failures = Lists.newArrayListWithExpectedSize((int)0);
        for (RealizedStep step : this.realizedSteps) {
            try {
                step.close();
            }
            catch (Exception e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new AutoClosingException(this, failures);
        }
    }

    public Set<RealizedStep> getStartSteps() {
        return this.realizedSteps.stream().filter(RealizedStep::hasNoDependencies).collect(Collectors.toSet());
    }

    public Set<RealizedStep> getEndSteps() {
        HashSet<RealizedStep> set = new HashSet<RealizedStep>(this.realizedSteps);
        for (RealizedStep realizedStep : this.realizedSteps) {
            realizedStep.getDependencies().forEach(set::remove);
        }
        return set;
    }

    public Set<RealizedStep> getDependents(RealizedStep step) {
        HashSet<RealizedStep> dependents = new HashSet<RealizedStep>();
        for (RealizedStep realizedStep : this.realizedSteps) {
            if (!realizedStep.getDependencies().contains(step)) continue;
            dependents.add(realizedStep);
        }
        return dependents;
    }

    public List<Problem> getFailures() {
        ArrayList failures = Lists.newArrayList();
        this.problems.stream().filter(Problem::isError).forEach(failures::add);
        for (RealizedStep step : this.realizedSteps) {
            if (!step.isDirectlyFailed()) continue;
            step.getFailureProblem().ifPresent(p -> failures.add(p));
        }
        return failures;
    }

    public boolean hasFailures() {
        return !this.getFailures().isEmpty();
    }

    public Optional<RealizedStep> getStep(String stepName) {
        for (RealizedStep realizedStep : this.realizedSteps) {
            if (!realizedStep.getName().equals(stepName)) continue;
            return Optional.of(realizedStep);
        }
        return Optional.empty();
    }

    public RealizedPipeline clone() {
        return this.clone(stepToCopy -> new RealizedStep(stepToCopy.getName(), stepToCopy.getImplementation(), stepToCopy.getAst(), stepToCopy.getResult(), new HashMap(stepToCopy.getBoundParameters()), new ArrayList<RealizedStep>(stepToCopy.getDependencies()), stepToCopy.getProduces()), new ArrayList<Problem>(this.problems));
    }

    private RealizedPipeline clone(Function<RealizedStep, RealizedStep> stepCloner, List<Problem> newProblems) {
        ArrayList<RealizedStep> clonedSteps = new ArrayList<RealizedStep>(this.realizedSteps.size());
        for (RealizedStep toCopy : this.realizedSteps) {
            clonedSteps.add(stepCloner.apply(toCopy));
        }
        for (RealizedStep clonedStep : clonedSteps) {
            ListIterator<RealizedStep> dependencies = clonedStep.getDependencies().listIterator();
            while (dependencies.hasNext()) {
                RealizedStep originalDependency = dependencies.next();
                int index = this.realizedSteps.indexOf(originalDependency);
                RealizedStep clonedDependency = (RealizedStep)clonedSteps.get(index);
                dependencies.set(clonedDependency);
            }
        }
        return new RealizedPipeline(this.context, this.ast, clonedSteps, newProblems, this.metadata);
    }

    public RealizedPipeline drainWarnings(Consumer<Problem> problemConsumer) {
        if (this.hasFailures()) {
            return this;
        }
        this.problems.stream().filter(p -> !p.isError()).forEach(problemConsumer::accept);
        return this.clone(stepToCopy -> new RealizedStep(stepToCopy.getName(), stepToCopy.getImplementation(), stepToCopy.getAst(), stepToCopy.getResult().drainWarnings(problemConsumer, (severity, ps) -> Problems.foundWith((Object)stepToCopy.getAst(), ps)), new HashMap(stepToCopy.getBoundParameters()), new ArrayList<RealizedStep>(stepToCopy.getDependencies()), stepToCopy.getProduces()), Collections.emptyList());
    }

    public PipelineMetadata getMetadata() {
        return this.metadata;
    }

    public RealizedPipeline withMetadata(PipelineMetadata newMetadata) {
        return new RealizedPipeline(this.context, this.ast, this.realizedSteps, this.problems, newMetadata);
    }

    public RealizedPipeline add(RealizedStep newStep) {
        for (RealizedStep existing : this.realizedSteps) {
            if (!newStep.getName().equals(existing.getName())) continue;
            String errorMessage = "Can not add step %s, name '%s' is not unique, already taken by %s".formatted(newStep, newStep.getName(), existing);
            throw new IllegalArgumentException(errorMessage);
        }
        block1: for (RealizedStep depStep : newStep.getDependencies()) {
            for (RealizedStep existingStep : this.realizedSteps) {
                if (existingStep != depStep) continue;
                continue block1;
            }
            throw new IllegalArgumentException("Step %s refers to a dependency not in this pipeline: %s".formatted(newStep, depStep));
        }
        ArrayList<RealizedStep> newSteps = new ArrayList<RealizedStep>(this.realizedSteps.size() + 1);
        newSteps.addAll(this.realizedSteps);
        newSteps.add(newStep);
        return new RealizedPipeline(this.context, this.ast, newSteps, this.problems, this.metadata);
    }

    public RealizedPipeline addProblems(Problem ... rest) {
        ArrayList<Problem> newProblems = new ArrayList<Problem>(this.problems.size() + rest.length);
        newProblems.addAll(this.problems);
        newProblems.addAll(List.of(rest));
        return new RealizedPipeline(this.context, this.ast, this.realizedSteps, newProblems, this.metadata);
    }

    @Generated
    public RealizedPipeline(ExecutionContext context, PipelineDeclaration ast, List<RealizedStep> realizedSteps, List<Problem> problems, PipelineMetadata metadata) {
        this.context = context;
        this.ast = ast;
        this.realizedSteps = realizedSteps;
        this.problems = problems;
        this.metadata = metadata;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RealizedPipeline)) {
            return false;
        }
        RealizedPipeline other = (RealizedPipeline)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExecutionContext this$context = this.getContext();
        ExecutionContext other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        PipelineDeclaration this$ast = this.getAst();
        PipelineDeclaration other$ast = other.getAst();
        if (this$ast == null ? other$ast != null : !((Object)this$ast).equals(other$ast)) {
            return false;
        }
        List<RealizedStep> this$realizedSteps = this.getRealizedSteps();
        List<RealizedStep> other$realizedSteps = other.getRealizedSteps();
        if (this$realizedSteps == null ? other$realizedSteps != null : !((Object)this$realizedSteps).equals(other$realizedSteps)) {
            return false;
        }
        List<Problem> this$problems = this.problems;
        List<Problem> other$problems = other.problems;
        if (this$problems == null ? other$problems != null : !((Object)this$problems).equals(other$problems)) {
            return false;
        }
        PipelineMetadata this$metadata = this.getMetadata();
        PipelineMetadata other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RealizedPipeline;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExecutionContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        PipelineDeclaration $ast = this.getAst();
        result = result * 59 + ($ast == null ? 43 : ((Object)$ast).hashCode());
        List<RealizedStep> $realizedSteps = this.getRealizedSteps();
        result = result * 59 + ($realizedSteps == null ? 43 : ((Object)$realizedSteps).hashCode());
        List<Problem> $problems = this.problems;
        result = result * 59 + ($problems == null ? 43 : ((Object)$problems).hashCode());
        PipelineMetadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    @Generated
    public ExecutionContext getContext() {
        return this.context;
    }

    @Generated
    public PipelineDeclaration getAst() {
        return this.ast;
    }

    @Generated
    public List<RealizedStep> getRealizedSteps() {
        return this.realizedSteps;
    }
}

