/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.pipeline;

import com.google.common.collect.Lists;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.engine.pipeline.RealizedStep;

public class Manifest {
    public static final String MANIFEST_FILE = "manifest.txt";
    private static final Pattern OUTPUT_FILE_PATTERN = Pattern.compile("^(?<filename>.*) \\(size=(?<size>.*), checksum=(?<checksum>.*)\\)$");
    private static final Pattern MANIFEST_FILE_PATTERN = Pattern.compile("^manifest.txt \\(checksum=(?<checksum>.*)\\)$");
    private static final char[] HEX_CODE = "0123456789ABCDEF".toCharArray();
    public String pipelineId;
    public String pipelineDescription;
    public List<StepDescription> steps;
    public LocalDateTime startTime;
    public LocalDateTime finishTime;
    public List<OutputInfo> outputs = Lists.newArrayList();
    public List<VersionInfo> versionInfo = Lists.newArrayList();
    public LocalInfo localInfo;

    private static void update(MessageDigest md, String filename, String size, String checksum) {
        md.update(filename.getBytes());
        md.update(size.getBytes());
        if (checksum != null) {
            md.update(checksum.getBytes());
        }
    }

    private static String checksum(Path file) {
        String string;
        MessageDigest md = Manifest.getDigestInstance();
        byte[] data = new byte[1024];
        FileInputStream fis = new FileInputStream(file.toFile());
        try {
            int read;
            while ((read = fis.read(data)) != -1) {
                md.update(data, 0, read);
            }
            string = Manifest.checksum(md);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RiskscapeIOException(String.format("Could not checksum file", file.toString()), e);
            }
        }
        fis.close();
        return string;
    }

    public static void verify(Path manifestFile, Formatter out) {
        if (Files.isDirectory(manifestFile, new LinkOption[0])) {
            manifestFile = manifestFile.resolve(MANIFEST_FILE);
        }
        if (!Files.exists(manifestFile, new LinkOption[0])) {
            out.format("%s does not exist. Aborting%n", manifestFile);
            return;
        }
        if (!Files.isReadable(manifestFile)) {
            out.format("%s cannot be read. Check file permissions. Aborting%n", manifestFile);
            return;
        }
        Path outputDirectory = manifestFile.getParent();
        try {
            List<String> manifestContent = Files.readAllLines(manifestFile);
            MessageDigest manifestDigest = Manifest.getDigestInstance();
            String manifestCheckSum = "";
            for (String line : manifestContent) {
                Matcher manifestMatcher;
                Matcher outputFileMatcher = OUTPUT_FILE_PATTERN.matcher(line);
                if (outputFileMatcher.matches()) {
                    String filename = outputFileMatcher.group("filename");
                    String size = outputFileMatcher.group("size");
                    String checksum = outputFileMatcher.group("checksum");
                    Path outputFile = outputDirectory.resolve(filename);
                    if (!Files.exists(outputFile, new LinkOption[0])) {
                        out.format("FAILED %s No such file or directory%n", outputFile);
                        return;
                    }
                    if (!Files.isReadable(outputFile)) {
                        out.format("FAILED %s Permission denied. Check file permissions%n", outputFile);
                        return;
                    }
                    if ("null".equals(checksum)) {
                        Manifest.update(manifestDigest, filename, size, null);
                        out.format("UNKNOWN %s checksum not available for verification%n", filename);
                    } else {
                        Manifest.update(manifestDigest, filename, size, checksum);
                        if (checksum.equals(Manifest.checksum(outputFile))) {
                            out.format("PASSED %s matches checksum%n", filename);
                        } else {
                            out.format("FAILED %s computed checksum does not match%n", filename);
                        }
                    }
                }
                if (!(manifestMatcher = MANIFEST_FILE_PATTERN.matcher(line)).matches()) continue;
                manifestCheckSum = manifestMatcher.group("checksum");
                break;
            }
            if (!manifestCheckSum.equals(Manifest.checksum(manifestDigest))) {
                out.format("FAILED %s computed checksum does not match%n", MANIFEST_FILE);
            }
        }
        catch (IOException ex) {
            out.format("FAILED, could not read manifest.txt. Cause: %s%n", ex.getMessage());
        }
    }

    public static MessageDigest getDigestInstance() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RiskscapeException("Could not get SHA-256 message digest", (Throwable)e);
        }
    }

    public static String checksum(MessageDigest md) {
        byte[] digest = md.digest();
        StringBuilder r = new StringBuilder(digest.length * 2);
        for (byte b : digest) {
            r.append(HEX_CODE[b >> 4 & 0xF]);
            r.append(HEX_CODE[b & 0xF]);
        }
        return r.toString().toLowerCase();
    }

    public Manifest() {
    }

    public Manifest(RealizedPipeline realized, LocalDateTime startTime) {
        this.pipelineDescription = realized.getMetadata().getDescription();
        this.pipelineId = realized.getMetadata().getName();
        this.steps = StepDescription.build(realized);
        this.startTime = startTime;
    }

    public Manifest(RealizedPipeline realized) {
        this(realized, LocalDateTime.now());
    }

    public void write(OutputStream output) {
        Formatter formatter = new Formatter(output);
        this.writeTo(formatter);
        formatter.flush();
    }

    public void writeTo(Formatter f) {
        f.format("Pipeline-ID: %s%n", this.pipelineId);
        f.format("Pipeline-Description: %s%n", this.pipelineDescription);
        f.format("Start-Time: %s%n", DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(this.startTime));
        f.format("Finish-Time: %s%n", DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(this.finishTime));
        if (!this.versionInfo.isEmpty()) {
            f.format("%n", new Object[0]);
            f.format("Riskscape Version%n", new Object[0]);
            f.format("-----------------%n", new Object[0]);
            for (VersionInfo version : this.versionInfo) {
                f.format("%s: %s%n", version.component, version.version);
            }
        }
        f.format("%n", new Object[0]);
        f.format("Host Information%n", new Object[0]);
        f.format("----------------%n", new Object[0]);
        f.format("User: %s%n", this.localInfo.user);
        f.format("Host: %s%n", this.localInfo.host);
        f.format("%n", new Object[0]);
        f.format("Pipeline Outputs%n", new Object[0]);
        f.format("----------------%n", new Object[0]);
        MessageDigest manifestDigest = Manifest.getDigestInstance();
        for (OutputInfo output : this.outputs) {
            f.format("%s (size=%s, checksum=%s)%n", output.filename, output.size, output.checksum);
            Manifest.update(manifestDigest, output.filename, output.size, output.checksum);
        }
        f.format("%s (checksum=%s)%n", MANIFEST_FILE, Manifest.checksum(manifestDigest));
        f.format("%n", new Object[0]);
        f.format("Pipeline Structure%n", new Object[0]);
        f.format("------------------%n", new Object[0]);
        for (StepDescription desc : this.steps) {
            f.format("%n%s", desc.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(OutputInfo info) {
        Manifest manifest = this;
        synchronized (manifest) {
            this.outputs.add(info);
        }
    }

    public static class StepDescription {
        public final String stepName;
        public final String stepId;
        public final List<String> dependsOn;
        public final Map<String, List<String>> parameterDescriptions;

        public static List<StepDescription> build(RealizedPipeline realized) {
            HashSet<RealizedStep> seen = new HashSet<RealizedStep>();
            ArrayList visitList = Lists.newArrayList(realized.getEndSteps());
            ArrayList descriptions = Lists.newArrayListWithCapacity((int)realized.getRealizedSteps().size());
            while (!visitList.isEmpty()) {
                RealizedStep step = (RealizedStep)visitList.remove(0);
                if (seen.contains(step)) continue;
                seen.add(step);
                StepDescription desc = new StepDescription(step);
                descriptions.add(desc);
                visitList.addAll(step.getDependencies());
            }
            Lists.reverse((List)descriptions);
            return descriptions;
        }

        public StepDescription(RealizedStep step) {
            this.stepName = step.getStepName();
            this.stepId = step.getImplementation().getId();
            this.dependsOn = step.getDependencies().stream().map(rs -> rs.getStepName()).collect(Collectors.toList());
            this.parameterDescriptions = new HashMap<String, List<String>>(step.getBoundParameters().size());
            for (Map.Entry<String, List<?>> boundParam : step.getBoundParameters().entrySet()) {
                List values = boundParam.getValue().stream().map(obj -> obj == null ? "null" : obj.toString()).collect(Collectors.toList());
                this.parameterDescriptions.put(boundParam.getKey(), values);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Formatter out = new Formatter(sb);
            out.format("Step-%s: %s%n", this.stepName, this.stepId);
            out.format("  Parameters: %n", new Object[0]);
            for (Map.Entry<String, List<String>> bound : this.parameterDescriptions.entrySet()) {
                out.format("    %s : %s%n", bound.getKey(), bound.getValue());
            }
            if (this.dependsOn != null && !this.dependsOn.isEmpty()) {
                out.format("  Depends On: %n", new Object[0]);
                for (String dependency : this.dependsOn) {
                    out.format("    %s%n", dependency);
                }
            }
            return sb.toString();
        }

        @Generated
        public StepDescription(String stepName, String stepId, List<String> dependsOn, Map<String, List<String>> parameterDescriptions) {
            this.stepName = stepName;
            this.stepId = stepId;
            this.dependsOn = dependsOn;
            this.parameterDescriptions = parameterDescriptions;
        }
    }

    public static class VersionInfo {
        public final String component;
        public final String version;

        @Generated
        public VersionInfo(String component, String version) {
            this.component = component;
            this.version = version;
        }
    }

    public static class LocalInfo {
        public final String user;
        public final String host;

        @Generated
        public LocalInfo(String user, String host) {
            this.user = user;
            this.host = host;
        }
    }

    public static class OutputInfo {
        public final String filename;
        public final String size;
        public final String checksum;

        public OutputInfo(String filename, String size, MessageDigest md) {
            this(filename, size, md != null ? Manifest.checksum(md) : null);
        }

        @Generated
        public OutputInfo(String filename, String size, String checksum) {
            this.filename = filename;
            this.size = size;
            this.checksum = checksum;
        }
    }
}

