/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.pipeline;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.pipeline.Collector;
import nz.org.riskscape.engine.relation.TupleIterator;

public class DefaultCollection<T>
implements Gauge<String> {
    private final Collector<T> collector;
    private String state = "waiting";
    private Timer accumulationTimer = new Timer();

    public TupleIterator lazilyCollected(TupleIterator collect) {
        return new LazyIterator(collect);
    }

    public TupleIterator collect(TupleIterator toCollect) {
        T accumulator = this.collector.newAccumulator();
        this.state = "started";
        while (toCollect.hasNext()) {
            Tuple collectThis = (Tuple)toCollect.next();
            long nanoStart = System.nanoTime();
            this.collector.accumulate(accumulator, collectThis);
            this.accumulationTimer.update(System.nanoTime() - nanoStart, TimeUnit.NANOSECONDS);
        }
        this.state = "finished";
        return this.collector.process(accumulator);
    }

    public void addMetrics(MetricRegistry registry, String prefix) {
        registry.register(prefix + "accumulation", (Metric)this.accumulationTimer);
        registry.register(prefix + "state", (Metric)this);
    }

    public String getValue() {
        return this.state;
    }

    @Generated
    public DefaultCollection(Collector<T> collector) {
        this.collector = collector;
    }

    private class LazyIterator
    implements TupleIterator {
        private final TupleIterator collectFrom;
        private TupleIterator built;

        LazyIterator(TupleIterator collectFrom) {
            this.collectFrom = collectFrom;
        }

        @Override
        public boolean hasNext() {
            if (this.built == null) {
                this.built = DefaultCollection.this.collect(this.collectFrom);
            }
            return this.built.hasNext();
        }

        @Override
        public Tuple next() {
            if (this.built == null) {
                this.built = DefaultCollection.this.collect(this.collectFrom);
            }
            return (Tuple)this.built.next();
        }
    }
}

