/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.pipeline;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.pipeline.Realized;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.types.Struct;

public interface Collector<T>
extends Realized {
    public Struct getSourceType();

    @Override
    public Struct getProducedType();

    @Deprecated
    default public Struct getTargetType() {
        return this.getProducedType();
    }

    public T newAccumulator();

    public void accumulate(T var1, Tuple var2);

    public T combine(T var1, T var2);

    public TupleIterator process(T var1);

    public Class<T> getAccumulatorClass();

    default public Set<Characteristic> getCharacteristics() {
        return Collections.emptySet();
    }

    default public boolean isParallelizable() {
        return this.getCharacteristics().contains((Object)Characteristic.PARALLELIZABLE);
    }

    default public Optional<Long> size(T accumulator) {
        return Optional.empty();
    }

    public static enum Characteristic {
        PARALLELIZABLE;

    }
}

